/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.viewer;

import apple.awt.CToolkit;
import com.sun.deploy.perf.DeployPerfUtil;
import com.sun.deploy.security.MacOSXDeadlockDetectionHook;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.util.DeployAWTUtil;
import com.sun.deploy.util.Trace;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.applet.AppletClassLoader;
import sun.applet.AppletEvent;
import sun.applet.AppletListener;
import sun.applet.AppletPanel;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.plugin.AppletStatusListener;
import sun.plugin.AppletViewer;
import sun.plugin.BeansApplet;
import sun.plugin.BeansViewer;
import sun.plugin.liveconnect.SecureInvocation;
import sun.plugin.services.BrowserService;
import sun.plugin.services.PlatformService;
import sun.plugin.util.NotifierObject;
import sun.plugin.viewer.LifeCycleManager;
import sun.plugin.viewer.context.PluginAppletContext;
import sun.plugin.viewer.context.PluginBeansContext;
import sun.plugin.viewer.context.WebKitAppletContext;
import sun.plugin.viewer.frame.WebKitEmbeddedFrame;
import sun.security.action.GetPropertyAction;

public class WebKitPluginObject
implements AppletListener {
    private WebKitEmbeddedFrame frame = null;
    protected AppletViewer panel = null;
    protected long id = -1L;
    private long handle = 0L;
    private int width = 0;
    private int height = 0;
    private String identifier = null;
    private boolean destroyed = false;
    private final Object syncDestroy = new Object();
    private boolean isAppletStoppedOrDestroyed = false;
    private AppletClassLoader tmpLoader;
    private boolean isLegacy = false;
    private static Boolean _liveconnectCompatibilityMode = null;
    private int startCount = -1;
    private boolean bInit = false;
    private final Object syncStartStop = new Object();

    WebKitPluginObject(long l, boolean bl, String string) {
        this.id = l;
        this.identifier = string;
        this.panel = LifeCycleManager.getAppletPanel(string);
        if (!bl) {
            PluginAppletContext pluginAppletContext;
            if (this.panel == null) {
                this.panel = new AppletViewer();
                this.panel.addAppletListener(this);
            }
            if ((pluginAppletContext = (PluginAppletContext)this.panel.getAppletContext()) == null) {
                BrowserService browserService = (BrowserService)ServiceManager.getService();
                pluginAppletContext = (PluginAppletContext)browserService.getAppletContext();
            }
            pluginAppletContext.setAppletContextHandle(l);
            this.panel.setAppletContext(pluginAppletContext);
        } else {
            PluginBeansContext pluginBeansContext;
            if (this.panel == null) {
                this.panel = new BeansViewer();
            }
            if ((pluginBeansContext = (PluginBeansContext)this.panel.getAppletContext()) == null) {
                BrowserService browserService = (BrowserService)ServiceManager.getService();
                pluginBeansContext = (PluginBeansContext)browserService.getBeansContext();
            }
            pluginBeansContext.setAppletContextHandle(l);
            this.panel.setAppletContext(pluginBeansContext);
        }
        this.isLegacy = this.panel.isLegacyLifeCycle();
    }

    private Applet getApplet() {
        return this.panel.getApplet();
    }

    private static boolean liveconnectCompatibilityMode() {
        if (_liveconnectCompatibilityMode == null) {
            _liveconnectCompatibilityMode = Boolean.FALSE;
            try {
                String string = AccessController.doPrivileged(new GetPropertyAction("apple.plugin.LiveConnect.CompatibilityMode"));
                if (string != null) {
                    _liveconnectCompatibilityMode = Boolean.valueOf(string);
                }
                if (_liveconnectCompatibilityMode.booleanValue()) {
                    System.out.println("[Java LiveConnect compatibility mode]: Enabled");
                }
            }
            catch (Exception exception) {
                Trace.securityPrintException((Throwable)exception);
            }
        }
        return _liveconnectCompatibilityMode;
    }

    private static void setLiveconnectCompatibilityMode(boolean bl) {
        if (bl) {
            _liveconnectCompatibilityMode = Boolean.TRUE;
            try {
                AccessController.doPrivileged(new SetPropertyAction("com.apple.eawt.CocoaComponent.CompatibilityMode", "always"));
                AccessController.doPrivileged(new SetPropertyAction("apple.plugin.LiveConnect.CompatibilityMode", "true"));
            }
            catch (Exception exception) {
                Trace.securityPrintException((Throwable)exception);
            }
            System.out.println("[Java LiveConnect compatibility mode]: Enabled");
        } else {
            _liveconnectCompatibilityMode = Boolean.FALSE;
        }
    }

    private Object liveConnectCall(Object object, Method method, String string, long l) throws Throwable {
        URL uRL = string != null ? new URL(string) : this.panel.getDocumentBase();
        Trace.liveConnectPrintln((String)("Java: Obj is <" + (object != null ? object.getClass().getName() : "null") + ">"));
        Trace.liveConnectPrintln((String)("Java: method is <" + method + ">"));
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray != null) {
            Trace.liveConnectPrintln((String)("Java:  method has " + classArray.length + " arguments."));
            for (int i = 0; i < classArray.length; ++i) {
                Trace.liveConnectPrintln((String)("Java:   arg[" + i + "].class = " + classArray[i]));
            }
        }
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            char c = this.getCharForJavaType(classArray[i]);
            objectArray[i] = this._convertJValueToObject(l, i, c);
        }
        Object object2 = null;
        if (WebKitPluginObject.liveconnectCompatibilityMode()) {
            object2 = SecureInvocation.directCallMethod(object.getClass(), object, method, objectArray, uRL.toString(), false, false);
        } else {
            long l2 = CToolkit.createAWTRunLoopMediator();
            object2 = SecureInvocation.CallMethod(l2, object.getClass(), object, method, objectArray, uRL.toString(), false, false);
        }
        Trace.liveConnectPrintln((String)("Java: Returning a " + (object2 != null ? object2.getClass().getName() : "null")));
        return object2;
    }

    private native Object _convertJValueToObject(long var1, int var3, char var4);

    private char getCharForJavaType(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return 'Z';
        }
        if (clazz == Byte.TYPE) {
            return 'B';
        }
        if (clazz == Character.TYPE) {
            return 'C';
        }
        if (clazz == Short.TYPE) {
            return 'S';
        }
        if (clazz == Integer.TYPE) {
            return 'I';
        }
        if (clazz == Long.TYPE) {
            return 'J';
        }
        if (clazz == Float.TYPE) {
            return 'F';
        }
        if (clazz == Double.TYPE) {
            return 'D';
        }
        return 'L';
    }

    public static void waitForNotification(NotifierObject notifierObject, long l) {
        long l2 = System.currentTimeMillis();
        while (!notifierObject.getNotified() && System.currentTimeMillis() - l2 < l) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private WebKitEmbeddedFrame createFrame(final long l, final int n, final int n2) {
        DeployPerfUtil.put((String)"START - Java   - ENV - create embedded browser frame (WebKit:Mac)");
        this.panel.createClassLoader();
        this.tmpLoader = this.panel.getAppletClassLoader();
        Thread thread = this.panel.getAppletHandlerThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        final long l2 = CToolkit.createAWTRunLoopMediator();
        Thread thread2 = new Thread(threadGroup, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WebKitPluginObject.this.frame = new WebKitEmbeddedFrame(l);
                try {
                    WebKitPluginObject.this.frame.setSize(n, n2);
                    WebKitPluginObject.this.frame.setVisible(true);
                    WebKitPluginObject.this.frame.setEnabled(true);
                }
                catch (Throwable throwable) {
                    Trace.printException((Throwable)throwable);
                }
                finally {
                    CToolkit.stopAWTRunLoop((long)l2);
                }
            }
        });
        thread2.start();
        CToolkit.doAWTRunLoop((long)l2);
        DeployPerfUtil.put((String)"END   - Java   - ENV - create embedded browser frame (WebKit:Mac)");
        return this.frame;
    }

    private void destroyFrame() {
        final NotifierObject notifierObject = new NotifierObject();
        DeployAWTUtil.invokeLater((Component)((Object)this.frame), (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WebKitPluginObject.this.frame.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    notifierObject.setNotified();
                }
            }
        });
        WebKitPluginObject.waitForNotification(notifierObject, 5000L);
        if (!notifierObject.getNotified()) {
            throw new RuntimeException("Error while destroying embedded frame");
        }
    }

    synchronized Frame setWindow(long l, int n, int n2) {
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if (this.handle == l) {
            return this.frame;
        }
        if (this.frame != null) {
            try {
                WebKitPluginObject.doSetVisibleAndEnabled((Component)((Object)this.frame), false, false);
            }
            catch (Throwable throwable) {
                Trace.printException((Throwable)throwable);
            }
            WindowEvent windowEvent = new WindowEvent((Window)((Object)this.frame), 201);
            DeployAWTUtil.postEvent((Component)((Object)this.frame), (AWTEvent)windowEvent);
        }
        this.frame = null;
        this.handle = l;
        if (l != 0L) {
            try {
                this.width = Integer.parseInt(this.getParameter("width"));
                this.height = Integer.parseInt(this.getParameter("height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.setParameter("width", new Integer(n));
                this.setParameter("height", new Integer(n2));
                this.width = n;
                this.height = n2;
            }
            catch (Throwable throwable) {
                Trace.printException((Throwable)throwable);
            }
            this.frame = this.createFrame(l, this.width, this.height);
            this.initPlugin();
        }
        return this.frame;
    }

    private synchronized void initPlugin() {
        assert (this.panel != null);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MacOSXDeadlockDetectionHook.installHook((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (WebKitPluginObject.this.id > 0L) {
                            WebKitPluginObject.this.notifyLoaded(WebKitPluginObject.this.id);
                        }
                    }
                });
                return null;
            }
        });
        if (this.frame != null) {
            this.panel.addAppletStatusListener(new WebKitAppletStatusListener(this.id));
            Applet applet = this.panel.getApplet();
            if (applet != null) {
                AppletPanel.changeFrameAppContext((Frame)((Object)this.frame), (AppContext)SunToolkit.targetToAppContext(applet));
            }
            WebKitPluginObject.doAddAndSetVisible((Container)((Object)this.frame), this.panel, true);
            if (!this.bInit) {
                this.bInit = true;
                LifeCycleManager.checkLifeCycle(this.panel);
                LifeCycleManager.loadAppletPanel(this.panel);
                LifeCycleManager.initAppletPanel(this.panel);
                if (this.startCount > 0) {
                    this.startCount = 0;
                    this.startPlugin();
                } else if (this.startCount == 0) {
                    this.startPlugin();
                    this.stopPlugin();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startPlugin() {
        assert (this.panel != null);
        if (this.bInit) {
            Object object = this.syncStartStop;
            synchronized (object) {
                WebKitPluginObject.doStartAppletPanel((Component)((Object)this.panel));
            }
        }
        WebKitPluginObject webKitPluginObject = this;
        synchronized (webKitPluginObject) {
            if (this.startCount < 0) {
                this.startCount = 0;
            }
            ++this.startCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopPlugin() {
        assert (this.panel != null);
        if (this.bInit) {
            Object object = this.syncStartStop;
            synchronized (object) {
                WebKitPluginObject.doStopAppletPanel((Component)((Object)this.panel));
            }
        }
        WebKitPluginObject webKitPluginObject = this;
        synchronized (webKitPluginObject) {
            --this.startCount;
        }
    }

    void destroyPlugin() {
        this.destroyPlugin(0L);
    }

    void destroyPlugin(long l) {
        assert (this.panel != null);
        final PlatformService platformService = PlatformService.getService();
        final long l2 = platformService.createEvent();
        final PluginAppletContext pluginAppletContext = (PluginAppletContext)this.panel.getAppletContext();
        Thread thread = new Thread(SunToolkit.targetToAppContext((Object)this.frame).getThreadGroup(), "applet-shutdown"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = WebKitPluginObject.this;
                    synchronized (object) {
                        WebKitPluginObject.this.destroyed = true;
                    }
                    if (!WebKitPluginObject.this.bInit) {
                        if (WebKitPluginObject.this.frame != null) {
                            WebKitPluginObject.this.destroyFrame();
                        }
                        return;
                    }
                    WebKitPluginObject.this.panel.waitForLoadingDone(5000L);
                    WebKitPluginObject.this.isAppletStoppedOrDestroyed = false;
                    LifeCycleManager.destroyAppletPanel(WebKitPluginObject.this.identifier, WebKitPluginObject.this.panel);
                    if (WebKitPluginObject.this.panel.getAppletHandlerThread() != null && WebKitPluginObject.this.getLoadingStatus() != 7) {
                        object = WebKitPluginObject.this.syncDestroy;
                        synchronized (object) {
                            if (!WebKitPluginObject.this.isAppletStoppedOrDestroyed) {
                                WebKitPluginObject.this.syncDestroy.wait(5000L);
                            }
                        }
                    }
                    pluginAppletContext.setAppletContextHandle(0L);
                    WebKitPluginObject.this.destroyFrame();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    platformService.signalEvent(l2);
                }
            }
        };
        thread.start();
        platformService.waitEvent(l, l2, 10000L);
        platformService.deleteEvent(l2);
        this.panel.removeAppletStatusListener(null);
        ((WebKitAppletContext)pluginAppletContext).onClose();
        if (pluginAppletContext != null) {
            pluginAppletContext.setAppletContextHandle(0L);
        }
        if (this.bInit) {
            LifeCycleManager.cleanupAppletPanel(this.panel);
        } else {
            this.panel.miniCleanup();
        }
        final AppletViewer appletViewer = this.panel;
        new Thread("finalCleanupThread"){

            @Override
            public void run() {
                LifeCycleManager.releaseAppletPanel(appletViewer);
            }
        }.start();
        this.id = 0L;
        this.panel = null;
        this.frame = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signal(int n) {
        switch (n) {
            case 4: {
                if (!this.isLegacy) break;
                Object object = this.syncDestroy;
                synchronized (object) {
                    this.isAppletStoppedOrDestroyed = true;
                    this.syncDestroy.notify();
                    break;
                }
            }
            case 0: 
            case 5: {
                if (this.isLegacy) break;
                Object object = this.syncDestroy;
                synchronized (object) {
                    this.isAppletStoppedOrDestroyed = true;
                    this.syncDestroy.notify();
                    break;
                }
            }
            case 6: 
            case 7: {
                Object object = this.syncDestroy;
                synchronized (object) {
                    this.isAppletStoppedOrDestroyed = true;
                    this.syncDestroy.notify();
                    break;
                }
            }
        }
    }

    synchronized void setDocumentURL(String string) {
        assert (this.panel != null);
        try {
            this.notifyAll();
            this.panel.setDocumentBase(string);
        }
        catch (Throwable throwable) {
            Trace.printException((Throwable)throwable);
        }
    }

    private Frame getFrame() {
        return this.frame;
    }

    void setFocus() {
        if (this.frame != null) {
            this.frame.synthesizeWindowActivation(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFrameSize(final int n, final int n2) {
        if (n > 0 && n2 > 0) {
            WebKitPluginObject webKitPluginObject = this;
            synchronized (webKitPluginObject) {
                this.setParameter("width", new Integer(n));
                this.setParameter("height", new Integer(n2));
            }
            if (this.frame == null) {
                return;
            }
            DeployAWTUtil.invokeLater((Component)((Object)this.frame), (Runnable)new Runnable(){

                @Override
                public void run() {
                    WebKitPluginObject.this.frame.setSize(n, n2);
                    if (WebKitPluginObject.this.panel != null) {
                        AppletViewer appletViewer = WebKitPluginObject.this.panel;
                        ((Component)((Object)appletViewer)).setSize(n, n2);
                        WebKitPluginObject.this.panel.setParameter("width", new Integer(n));
                        WebKitPluginObject.this.panel.setParameter("height", new Integer(n2));
                        Object object = WebKitPluginObject.this.panel.getViewedObject();
                        if (object != null) {
                            Applet applet;
                            if (object instanceof Applet) {
                                applet = (Applet)object;
                            } else {
                                Component component = (Component)object;
                                component.setSize(n, n2);
                                applet = (Applet)component.getParent();
                            }
                            if (applet != null) {
                                WebKitPluginObject.doSetSize((Component)((Object)WebKitPluginObject.this.frame), WebKitPluginObject.this.panel, object, n, n2);
                            }
                        }
                    }
                }
            });
        }
    }

    public Object getJavaObject() {
        Object object = null;
        if (this.panel != null) {
            object = this.panel.getViewedObject();
        }
        if (object instanceof BeansApplet) {
            BeansApplet beansApplet = (BeansApplet)object;
            object = beansApplet.getBean();
        }
        return object;
    }

    int getLoadingStatus() {
        if (this.panel != null) {
            return this.panel.getLoadingStatus();
        }
        return 7;
    }

    public String getParameter(String string) {
        assert (this.panel != null);
        return this.panel.getParameter(string);
    }

    public void setParameter(String string, Object object) {
        assert (this.panel != null);
        this.panel.setParameter(string, object);
    }

    public void setBoxColors() {
        this.panel.setColorAndText();
    }

    public void appletStateChanged(AppletEvent appletEvent) {
        AppletPanel appletPanel = (AppletPanel)appletEvent.getSource();
        switch (appletEvent.getID()) {
            case 51236: {
                if (this.frame == null) break;
                Applet applet = appletPanel.getApplet();
                if (applet != null) {
                    AppletPanel.changeFrameAppContext((Frame)((Object)this.frame), (AppContext)SunToolkit.targetToAppContext(applet));
                    break;
                }
                AppletPanel.changeFrameAppContext((Frame)((Object)this.frame), (AppContext)AppContext.getAppContext());
            }
        }
    }

    private native void notifyLoaded(long var1);

    private native void notifyStarted(long var1);

    private static void doSetSize(final Component component, final AppletViewer appletViewer, final Object object, final int n, final int n2) {
        WebKitPluginObject.doRunnable(new Runnable(){

            @Override
            public void run() {
                if (component != null) {
                    component.setSize(n, n2);
                }
                if (appletViewer != null) {
                    appletViewer.setSize(n, n2);
                }
                if (object != null) {
                    Applet applet;
                    if (object instanceof Applet) {
                        applet = (Applet)object;
                    } else {
                        Component component2 = (Component)object;
                        component2.setSize(n, n2);
                        applet = (Applet)component2.getParent();
                    }
                    if (applet != null) {
                        applet.resize(n, n2);
                    }
                }
            }
        }, component);
    }

    private static void doSetVisibleAndEnabled(final Component component, final boolean bl, final boolean bl2) {
        WebKitPluginObject.doRunnable(new Runnable(){

            @Override
            public void run() {
                component.setVisible(bl);
                component.setEnabled(bl2);
            }
        }, component);
    }

    private static void doAddAndSetVisible(final Container container, final AppletViewer appletViewer, final boolean bl) {
        WebKitPluginObject.doRunnable(new Runnable(){

            @Override
            public void run() {
                container.add((Component)((Object)appletViewer));
                container.setVisible(bl);
            }
        }, container);
    }

    private static void doStartAppletPanel(final Component component) {
        WebKitPluginObject.doRunnable(new Runnable(){

            @Override
            public void run() {
                LifeCycleManager.startAppletPanel((AppletViewer)((Object)component));
            }
        }, component);
    }

    private static void doStopAppletPanel(final Component component) {
        WebKitPluginObject.doRunnable(new Runnable(){

            @Override
            public void run() {
                LifeCycleManager.stopAppletPanel((AppletViewer)((Object)component));
            }
        }, component);
    }

    private static void doRunnable(Runnable runnable, Component component) {
        try {
            CToolkit.invokeAndWait((Runnable)runnable, (Component)component);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private class WebKitAppletStatusListener
    implements AppletStatusListener {
        private long viewID = 0L;
        private boolean gotLoad = false;

        WebKitAppletStatusListener(long l) {
            this.viewID = l;
        }

        @Override
        public void statusChanged(int n) {
            if (n == 3) {
                WebKitPluginObject.this.notifyStarted(this.viewID);
            } else if (n == 2 || n == 7) {
                if (WebKitPluginObject.this.id > 0L) {
                    WebKitPluginObject.this.notifyLoaded(WebKitPluginObject.this.id);
                }
            } else if (n == 1) {
                if (this.gotLoad && WebKitPluginObject.this.id > 0L) {
                    WebKitPluginObject.this.notifyLoaded(WebKitPluginObject.this.id);
                }
                this.gotLoad = true;
            }
            WebKitPluginObject.this.signal(n);
        }
    }

    private static class SetPropertyAction
    implements PrivilegedAction {
        private String theProp;
        private String theValue;

        public SetPropertyAction(String string, String string2) {
            this.theProp = string;
            this.theValue = string2;
        }

        public Object run() {
            System.setProperty(this.theProp, this.theValue);
            return null;
        }
    }
}

