/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.util.Trace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.ImageObserver;
import sun.plugin.util.AnimationPanel2;
import sun.plugin.util.AnimationPanelBase;
import sun.plugin.util.ErrorDelegate;
import sun.plugin.util.ErrorPanel;
import sun.plugin.util.UIUtil;

class GrayBoxPanel
extends Panel
implements ComponentListener,
ImageObserver {
    private static final Color LOADING_BORDER = new Color(153, 153, 153);
    private Color backgroundColor;
    private Color foregroundColor;
    private ErrorPanel err_panel = null;
    private AnimationPanelBase m_panel = null;
    private static final boolean USE_NEW_ANIMATION = true;
    private Container m_parent;
    private int m_maxValue;
    private boolean m_boxBorder = true;
    private Image m_image = null;
    private boolean m_imageIsCentered = false;
    private boolean m_animateImage = true;
    private boolean m_error = false;
    private ErrorDelegate errorDelegate = null;
    long startTimeMillis;
    int endSequenceMillis = 2000;
    private Image backBufferImage;
    private int backBufferImageWidth;
    private int backBufferImageHeight;

    public GrayBoxPanel(Container container) {
        this(container, Color.WHITE);
    }

    public GrayBoxPanel(Container container, Color color) {
        this(container, color, Color.BLACK);
    }

    public GrayBoxPanel(Container container, Color color, Color color2) {
        this(container, color, color2, null);
    }

    public GrayBoxPanel(Container container, Color color, Color color2, ErrorDelegate errorDelegate) {
        this.m_parent = container;
        this.setBgColor(color);
        this.setFgColor(color2);
        this.errorDelegate = errorDelegate;
        this.setLayout(new BorderLayout());
        UIUtil.disableBackgroundErase(this);
    }

    public void setCustomImage(Image image, boolean bl) {
        this.setImage(image, bl);
    }

    public void setBgColor(Color color) {
        this.backgroundColor = color;
        this.setBackground(color);
        if (this.m_panel != null) {
            this.m_panel.setBoxBGColor(color);
        }
    }

    public void setFgColor(Color color) {
        this.foregroundColor = color;
        this.setForeground(color);
        if (this.m_panel != null) {
            this.m_panel.setBoxFGColor(color);
        }
    }

    public void setBoxBorder(boolean bl) {
        this.m_boxBorder = bl;
    }

    public void setError() {
        if (this.m_panel != null) {
            this.m_panel.stopAnimation();
            this.removeAll();
            this.m_panel = null;
            this.validate();
        }
        if (this.m_error) {
            return;
        }
        if (this.err_panel == null) {
            this.err_panel = new ErrorPanel(this.backgroundColor, this.foregroundColor, this.m_parent, this.errorDelegate);
            this.add((Component)this.err_panel, "Center");
            this.m_error = true;
            this.validate();
        }
        this.repaint();
    }

    public void setMaxProgressValue(int n) {
        this.m_maxValue = n;
    }

    public void progress(int n) {
        long l = (long)(this.m_maxValue - n) * (System.currentTimeMillis() - this.startTimeMillis) / (long)(n + 1);
        if (this.m_panel != null) {
            float f = (float)n / (float)this.m_maxValue;
            if (l > (long)this.endSequenceMillis) {
                this.m_panel.setProgressValue(f);
            } else {
                this.m_panel.fadeAway();
            }
        } else {
            this.repaint();
        }
    }

    public void start() {
        Dimension dimension = this.m_parent.getSize();
        if (this.m_panel == null && this.m_image == null) {
            this.m_panel = new AnimationPanel2();
            this.m_panel.setCursor(new Cursor(12));
            this.add((Component)this.m_panel, "Center");
            this.m_panel.setBoxBGColor(this.backgroundColor);
            this.m_panel.setBoxFGColor(this.foregroundColor);
        }
        this.startTimeMillis = System.currentTimeMillis();
        if (this.m_panel != null) {
            this.m_panel.startAnimation();
        } else if (this.m_image != null) {
            this.m_animateImage = true;
            this.repaint();
        }
        this.m_parent.addComponentListener(this);
    }

    public void stop() {
        if (this.m_panel != null) {
            this.m_panel.stopAnimation();
        }
        this.m_animateImage = false;
        this.m_parent.removeComponentListener(this);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            Dimension dimension = this.m_parent.getSize();
            if (this.m_panel != null) {
                this.m_panel.repaint();
            } else if (this.m_error) {
                this.err_panel.repaint();
            } else {
                int n;
                if (this.backBufferImage == null || this.backBufferImageWidth != dimension.width || this.backBufferImageHeight != dimension.height) {
                    if (this.backBufferImage != null) {
                        this.backBufferImage.flush();
                    }
                    int n2 = Math.max(1, dimension.width);
                    n = Math.max(1, dimension.height);
                    this.backBufferImage = this.createImage(n2, n);
                    this.backBufferImageWidth = n2;
                    this.backBufferImageHeight = n;
                }
                Graphics graphics2 = this.backBufferImage.getGraphics();
                graphics2.setColor(this.backgroundColor);
                graphics2.fillRect(0, 0, this.backBufferImageWidth, this.backBufferImageHeight);
                if (this.m_image != null) {
                    n = this.m_image.getWidth(this);
                    int n3 = this.m_image.getHeight(this);
                    if (this.m_imageIsCentered && n >= 0 && n3 >= 0) {
                        this.drawImage(graphics2, this.m_image, (this.backBufferImageWidth - n) / 2, (this.backBufferImageHeight - n3) / 2);
                    } else if (dimension.width > 24 && dimension.height > 24) {
                        this.drawImage(graphics2, this.m_image, 1, 1);
                    } else {
                        this.drawImage(graphics2, this.m_image, 0, 0);
                    }
                }
                graphics.drawImage(this.backBufferImage, 0, 0, null);
            }
            if (this.m_boxBorder && dimension.width > 24 && dimension.height > 24) {
                this.drawBorder(graphics, dimension);
            }
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
        }
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x10) != 0) {
            if (this.m_animateImage) {
                this.repaint();
            }
            return this.m_animateImage;
        }
        if ((n & 0x20) != 0) {
            this.repaint();
        }
        return true;
    }

    private void drawImage(Graphics graphics, Image image, int n, int n2) {
        graphics.drawImage(image, n, n2, this.backgroundColor, this);
    }

    private void drawBorder(Graphics graphics, Dimension dimension) {
        Color color = LOADING_BORDER;
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.setColor(color2);
    }

    private synchronized void setImage(Image image, boolean bl) {
        if (this.m_panel != null) {
            this.m_panel.stopAnimation();
            this.removeAll();
            this.m_panel = null;
        }
        this.m_image = image;
        this.m_imageIsCentered = bl;
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.m_parent.getSize();
        this.setSize(dimension);
        if (this.m_panel != null) {
            this.m_panel.setSize(dimension);
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }
}

