/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.util.Trace;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import sun.plugin.util.AnimationPanelBase;
import sun.plugin.util.UIUtil;

public class AnimationPanel2
extends AnimationPanelBase {
    private static boolean DEBUG;
    private static final int ANIMATION_CYCLE_TIME = 2000;
    private static final int ZIPPY_PULSE_TIME = 300;
    private static final long[] stateStops;
    private static final String JAVA_LOGO_IMAGE = "JavaCupLogo-161.png";
    private static final String JAVA_COM_IMAGE = "javacom300.png";
    private Color bgColor;
    private Color fgColor = Color.BLACK;
    private Image javaLogoImage;
    private Image javaComImage;
    private boolean preloadedAll = false;
    private boolean errorDuringPreloading = false;
    private Image backbuffer = null;
    private float loadingProgress;
    private float spinnerProgress;
    private static final int NUM_SPINNER_STOPS = 16;
    private static final int SPINNER_R = 84;
    private static final int SPINNER_G = 130;
    private static final int SPINNER_B = 161;
    private long startTime;
    private long initialStartTime;
    private int currentState = 1;
    private float stateProgress;
    private boolean showLogoAndText;
    private float zippyProgress;
    private float zippyStartProgress;
    private long zippyStartTime;
    private boolean fadeAway;
    private boolean paused;
    private boolean animationThreadRunning = false;

    public AnimationPanel2() {
        if (DEBUG) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    AnimationPanel2.this.paused = !AnimationPanel2.this.paused;
                }
            });
        }
        UIUtil.disableBackgroundErase(this);
        this.setBoxBGColor(Color.WHITE);
    }

    @Override
    public void setBoxBGColor(Color color) {
        this.setBackground(color);
        this.bgColor = color;
    }

    @Override
    public void setBoxFGColor(Color color) {
        this.fgColor = color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAnimation() {
        AnimationPanel2 animationPanel2 = this;
        synchronized (animationPanel2) {
            if (this.animationThreadRunning) {
                return;
            }
            this.animationThreadRunning = true;
        }
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAnimation() {
        AnimationPanel2 animationPanel2 = this;
        synchronized (animationPanel2) {
            this.animationThreadRunning = false;
        }
    }

    @Override
    public float getProgressValue() {
        return this.loadingProgress;
    }

    @Override
    public void setProgressValue(float f) {
        this.zippyStartTime = 0L;
        this.zippyStartProgress = this.zippyProgress;
        this.loadingProgress = f;
    }

    @Override
    public void fadeAway() {
        if (this.currentState == 2 && !this.fadeAway) {
            this.setProgressValue(1.0f);
            this.fadeAway = true;
        }
    }

    private Image loadImage(Toolkit toolkit, String string) {
        return toolkit.createImage(this.getClass().getResource(string));
    }

    private void preloadResources() {
        if (this.preloadedAll || this.errorDuringPreloading) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        MediaTracker mediaTracker = new MediaTracker(this);
        this.javaLogoImage = this.loadImage(toolkit, JAVA_LOGO_IMAGE);
        mediaTracker.addImage(this.javaLogoImage, 0);
        this.javaComImage = this.loadImage(toolkit, JAVA_COM_IMAGE);
        mediaTracker.addImage(this.javaComImage, 1);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            this.errorDuringPreloading = true;
            return;
        }
        this.preloadedAll = true;
    }

    private void allocateBackBuffer(int n, int n2) {
        if (this.backbuffer != null && (this.backbuffer.getWidth(null) != n || this.backbuffer.getHeight(null) != n2)) {
            this.backbuffer.flush();
            this.backbuffer = null;
        }
        if (this.backbuffer == null) {
            this.backbuffer = this.createImage(n, n2);
        }
    }

    private Dimension getImageBoundsWithinSize(int n, int n2, int n3, float f) {
        float f2 = f * (float)n3 / (float)Math.sqrt(n * n + n2 * n2);
        return new Dimension((int)((float)n * f2), (int)((float)n2 * f2));
    }

    private static float bias(float f, float f2) {
        return f2 + f * (1.0f - f2);
    }

    private void renderSpinner(Graphics2D graphics2D, int n, int n2, int n3) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n4 = (int)Math.max(1.0f, 0.04f * (float)n3);
        int n5 = (int)Math.max(1.0f, 0.05f * (float)n3);
        int n6 = (int)Math.max(1.0f, 0.35f * (float)n3);
        int n7 = n / 2;
        int n8 = n2 / 2;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate((double)n7, (float)n8 - 0.05f * (float)n3);
        if (this.showLogoAndText) {
            Dimension dimension = this.getImageBoundsWithinSize(this.javaLogoImage.getWidth(null), this.javaLogoImage.getHeight(null), n3, 0.6f);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.drawImage(this.javaLogoImage, -dimension.width / 2, -dimension.height / 2, dimension.width, dimension.height, null);
        }
        double d = 0.39269908169872414;
        int n9 = this.showLogoAndText ? 1 : 5;
        int[] nArray = new int[]{-n5, n5, n4, -n4};
        int[] nArray2 = new int[]{-n5, -n5, n9 * n4, n9 * n4};
        graphics2D.rotate(-d / 2.0);
        graphics2D.translate(0, -n6);
        float f = 0.1f;
        float f2 = this.spinnerProgress;
        float f3 = 0.0625f;
        for (int i = 0; i < 16; ++i) {
            float f4;
            graphics2D.translate(0, n6);
            graphics2D.rotate(-d);
            graphics2D.translate(0, -n6);
            float f5 = f4 + f3;
            boolean bl = false;
            for (f4 = (float)i * f3 + f2; f4 > 1.0f; f4 -= 1.0f) {
            }
            while (f5 > 1.0f) {
                f5 -= 1.0f;
            }
            if (f4 > f5) {
                bl = true;
            }
            if (!bl) {
                GradientPaint gradientPaint = new GradientPaint(-n5, 0.0f, new Color(84, 130, 161, (int)(255.0f * AnimationPanel2.bias(1.0f - f4, f))), n5, 0.0f, new Color(84, 130, 161, (int)(255.0f * AnimationPanel2.bias(1.0f - f5, f))));
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillPolygon(nArray, nArray2, nArray.length);
                continue;
            }
            float f6 = f5 / f3;
            int n10 = (int)(f6 * 2.0f * (float)n5);
            int n11 = (int)(f6 * 2.0f * (float)n4);
            GradientPaint gradientPaint = new GradientPaint(-n5 + n10, 0.0f, new Color(84, 130, 161, (int)(255.0f * AnimationPanel2.bias(0.0f, f))), n5, 0.0f, new Color(84, 130, 161, (int)(255.0f * AnimationPanel2.bias(f5, f))));
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillPolygon(new int[]{-n5 + n10, n5, n4, -n4 + n11}, nArray2, nArray2.length);
            gradientPaint = new GradientPaint(-n5, 0.0f, new Color(84, 130, 161, (int)(255.0f * AnimationPanel2.bias(f4, f))), -n5 + n10, 0.0f, new Color(84, 130, 161, (int)(255.0f * AnimationPanel2.bias(1.0f, f))));
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillPolygon(new int[]{-n5, -n5 + n10, -n4 + n11, -n4}, nArray2, nArray2.length);
        }
        graphics2D.setTransform(affineTransform);
    }

    private void renderProgress(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4 = (int)((float)n3 * 0.7f);
        int n5 = (int)Math.max(4.0f, (float)n3 * 0.05f);
        n5 = Math.min(8, n5);
        int n6 = (n - n4) / 2;
        int n7 = (int)(((float)n2 + 0.9f * (float)n3) / 2.0f) - n5;
        graphics2D.setColor(this.fgColor);
        graphics2D.drawRect(n6, n7, n4, n5);
        int n8 = (int)((float)n4 * this.zippyProgress);
        graphics2D.fillRect(n6 + 2, n7 + 2, n8 - 3, n5 - 3);
    }

    private void renderJavaCom(Graphics2D graphics2D, int n, int n2, int n3) {
        if (this.showLogoAndText) {
            int n4 = n / 2;
            int n5 = n2 / 2;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate((double)n4, (float)n5 - 0.05f * (float)n3);
            Dimension dimension = this.getImageBoundsWithinSize(this.javaComImage.getWidth(null), this.javaComImage.getHeight(null), n3, 0.6f);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.drawImage(this.javaComImage, -dimension.width / 2, -dimension.height / 2, dimension.width, dimension.height, null);
        }
    }

    private void renderState1(Graphics2D graphics2D, int n, int n2, int n3) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.stateProgress));
        this.renderSpinner(graphics2D, n, n2, n3);
        this.renderProgress(graphics2D, n, n2, n3);
    }

    private void renderState2(Graphics2D graphics2D, int n, int n2, int n3) {
        this.renderSpinner(graphics2D, n, n2, n3);
        this.renderProgress(graphics2D, n, n2, n3);
    }

    private void renderState3(Graphics2D graphics2D, int n, int n2, int n3) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - this.stateProgress));
        this.renderSpinner(graphics2D, n, n2, n3);
        this.renderProgress(graphics2D, n, n2, n3);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.stateProgress));
        this.renderJavaCom(graphics2D, n, n2, n3);
        graphics2D.setComposite(composite);
    }

    private void renderState4(Graphics2D graphics2D, int n, int n2, int n3) {
        if (this.showLogoAndText) {
            this.renderJavaCom(graphics2D, n, n2, n3);
        } else {
            ++this.currentState;
        }
    }

    private void renderState5(Graphics2D graphics2D, int n, int n2, int n3) {
        if (this.showLogoAndText) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - this.stateProgress));
            this.renderJavaCom(graphics2D, n, n2, n3);
            graphics2D.setComposite(composite);
        } else {
            ++this.currentState;
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (DEBUG || !this.animationThreadRunning) {
            try {
                this.doPaint(graphics);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void doPaint(Graphics graphics) {
        int n;
        int n2 = this.getWidth();
        int n3 = AnimationPanel2.getBoxSize(n2, n = this.getHeight());
        if (n3 <= 0) {
            graphics.setColor(this.bgColor);
            graphics.fillRect(0, 0, n2, n);
            return;
        }
        this.preloadResources();
        if (!this.preloadedAll) {
            return;
        }
        this.allocateBackBuffer(n2, n);
        this.showLogoAndText = n3 >= 50;
        Graphics2D graphics2D = (Graphics2D)this.backbuffer.getGraphics();
        graphics2D.setColor(this.bgColor);
        graphics2D.fillRect(0, 0, n2, n);
        switch (this.currentState) {
            case 1: {
                this.renderState1(graphics2D, n2, n, n3);
                break;
            }
            case 2: {
                this.renderState2(graphics2D, n2, n, n3);
                break;
            }
            case 3: {
                this.renderState3(graphics2D, n2, n, n3);
                break;
            }
            case 4: {
                this.renderState4(graphics2D, n2, n, n3);
                break;
            }
            case 5: {
                this.renderState5(graphics2D, n2, n, n3);
                break;
            }
        }
        graphics2D.dispose();
        graphics.drawImage(this.backbuffer, 0, 0, null);
    }

    private static int getBoxSize(int n, int n2) {
        int n3;
        int n4 = n3 = n > n2 ? n2 : n;
        if (n3 < 25) {
            return 0;
        }
        if (n3 < 200) {
            return (int)(0.75f * (float)n3);
        }
        if (n3 < 300) {
            return 150;
        }
        if (n3 > 600) {
            return 300;
        }
        return n3 / 2;
    }

    private static float convertToNonLinear(float f, float f2, float f3) {
        float f4 = 1.0f / (1.0f - f2 / 2.0f - f3 / 2.0f);
        if (f < f2) {
            float f5 = f4 * (f / f2) / 2.0f;
            f *= f5;
        } else if (f > 1.0f - f3) {
            float f6 = f - (1.0f - f3);
            float f7 = f6 / f3;
            f = f4 * (1.0f - f2 / 2.0f - f3 + f6 * (2.0f - f7) / 2.0f);
        } else {
            f = f4 * (f - f2 / 2.0f);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            AnimationPanel2 animationPanel2 = this;
            synchronized (animationPanel2) {
                if (!this.animationThreadRunning) {
                    break;
                }
            }
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            long l = System.currentTimeMillis();
            if (DEBUG && this.paused) {
                this.startTime = l - (long)(this.stateProgress * (float)stateStops[this.currentState]);
                continue;
            }
            if (this.isShowing()) {
                try {
                    this.doPaint(this.getGraphics());
                }
                catch (RuntimeException runtimeException) {
                    Trace.ignoredException((Exception)runtimeException);
                }
            }
            long l2 = l - this.startTime;
            if (this.initialStartTime == 0L) {
                this.initialStartTime = this.startTime;
            }
            long l3 = l - this.initialStartTime;
            if (this.currentState < stateStops.length) {
                if (l2 >= stateStops[this.currentState]) {
                    this.startTime = l;
                    this.stateProgress = 0.0f;
                    l2 = 0L;
                    ++this.currentState;
                } else {
                    this.stateProgress = (float)l2 / (float)stateStops[this.currentState];
                }
            }
            if (this.currentState < 6) {
                long l4;
                this.spinnerProgress = (float)(l3 % 2000L) / 2000.0f;
                if (this.zippyStartTime == 0L) {
                    this.zippyStartTime = l;
                }
                if ((l4 = l - this.zippyStartTime) > 300L) {
                    this.zippyProgress = this.loadingProgress;
                } else {
                    float f = (float)l4 / 300.0f;
                    f = AnimationPanel2.convertToNonLinear(f, 0.5f, 0.1f);
                    this.zippyProgress = this.zippyStartProgress + (this.loadingProgress - this.zippyStartProgress) * f;
                }
                if (!this.fadeAway || !(this.zippyProgress >= 1.0f)) continue;
                this.fadeAway = false;
                this.zippyProgress = 1.0f;
                this.loadingProgress = 1.0f;
                this.startTime = l;
                ++this.currentState;
                continue;
            }
            if (DEBUG && this.currentState > 6) {
                this.loadingProgress = 0.0f;
                this.zippyStartProgress = 0.0f;
                this.zippyProgress = 0.0f;
                this.zippyStartTime = 0L;
                this.startTime = l;
                this.initialStartTime = 0L;
                this.currentState = 1;
                continue;
            }
            AnimationPanel2 animationPanel22 = this;
            synchronized (animationPanel22) {
                this.animationThreadRunning = false;
            }
        }
    }

    public static void main(String[] stringArray) {
        DEBUG = true;
        final AnimationPanel2 animationPanel2 = new AnimationPanel2();
        if (stringArray.length > 0 && stringArray[0].equals("-reverse")) {
            animationPanel2.setBoxBGColor(Color.BLACK);
            animationPanel2.setBoxFGColor(Color.WHITE);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    animationPanel2.setPreferredSize(new Dimension(400, 300));
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    animationPanel2.setSize(new Dimension(400, 300));
                }
                Frame frame = new Frame("Java Plugin Animation - 2008 Prototype");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                frame.add(animationPanel2);
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                animationPanel2.startAnimation();
            }
        });
        while (true) {
            try {
                Thread.sleep(1200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            float f = animationPanel2.getProgressValue();
            f += 0.15f;
            if (f >= 0.9f) {
                animationPanel2.fadeAway();
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                f = 0.0f;
            }
            animationPanel2.setProgressValue(f);
        }
    }

    static {
        stateStops = new long[]{0L, 300L, 99999999L, 750L, 950L, 300L, 1000L};
    }
}

