/*
 * Decompiled with CFR 0.152.
 */
package com.mlawrie.yajtl;

import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPortIn;
import com.mlawrie.yajtl.TUIOCursor;
import com.mlawrie.yajtl.TUIOEvent;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class TUIOReceiver {
    private OSCPortIn reciever;
    private OSCListener listener;
    protected Vector<TUIOCursor> cursors;
    int width;
    int height;
    private int port;
    protected TUIOEvent eventHandler = null;

    public void setHandler(TUIOEvent te) {
        this.eventHandler = te;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPort() {
        return this.port;
    }

    public TUIOReceiver(int w, int h) throws SocketException {
        this.init(w, h, 3333);
    }

    public TUIOReceiver(int screenWidth, int screenHeight, int _port) throws SocketException {
        this.init(screenWidth, screenHeight, _port);
    }

    protected void init(int sw, int sh, int _port) throws SocketException {
        this.cursors = new Vector();
        System.out.println("TUIO: (" + sw + "x" + sh + ") " + this.port);
        this.port = _port;
        this.width = sw;
        this.height = sh;
        this.reciever = new OSCPortIn(this.port);
        this.listener = new OSCListener(){

            public void acceptMessage(Date time, OSCMessage message) {
                Object[] args = message.getArguments();
                String command = (String)args[0];
                String address = message.getAddress();
                if (address.equals("/tuio/2Dcur")) {
                    if (command.equals("set")) {
                        TUIOReceiver.this.setCurCmd(args);
                    }
                    if (command.equals("alive")) {
                        TUIOReceiver.this.aliveCurCmd(args);
                    }
                    if (command.equals("fseq")) {
                        TUIOReceiver.this.fseqCurCmd(args);
                    }
                }
            }
        };
        this.reciever.addListener("/tuio/2Dobj", this.listener);
        this.reciever.addListener("/tuio/2Dcur", this.listener);
        this.reciever.startListening();
        System.out.print("started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurCmd(Object[] args) {
        Vector<TUIOCursor> vector = this.cursors;
        synchronized (vector) {
            long id = ((Integer)args[1]).longValue();
            float x = ((Float)args[2]).floatValue() * (float)this.width;
            float y = ((Float)args[3]).floatValue() * (float)this.height;
            boolean found = false;
            Enumeration<TUIOCursor> e = this.cursors.elements();
            while (e.hasMoreElements()) {
                TUIOCursor cur = e.nextElement();
                if (cur.id() != id) continue;
                if (cur.x() != x || cur.y() != y) {
                    cur.signalMoved(x, y);
                    if (this.eventHandler != null) {
                        this.eventHandler.moveCursorEvent(cur);
                    }
                } else {
                    cur.signalMoved(x, y);
                }
                found = true;
                break;
            }
            if (!found) {
                TUIOCursor cur = new TUIOCursor(x, y, id);
                this.cursors.add(cur);
                if (this.eventHandler != null) {
                    this.eventHandler.newCursorEvent(cur);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aliveCurCmd(Object[] args) {
        Vector<TUIOCursor> vector = this.cursors;
        synchronized (vector) {
            Enumeration<TUIOCursor> e = this.cursors.elements();
            while (e.hasMoreElements()) {
                e.nextElement().alive(false);
            }
            int i = 1;
            while (i < args.length) {
                long id = ((Integer)args[i]).longValue();
                Enumeration<TUIOCursor> e2 = this.cursors.elements();
                while (e2.hasMoreElements()) {
                    TUIOCursor cur = e2.nextElement();
                    if (cur.id() != id) continue;
                    cur.alive(true);
                }
                ++i;
            }
            e = this.cursors.elements();
            while (e.hasMoreElements()) {
                TUIOCursor cur = e.nextElement();
                if (cur.alive()) continue;
                if (this.eventHandler != null) {
                    this.eventHandler.removeCursorEvent(cur);
                }
                this.cursors.remove(cur);
            }
        }
    }

    private void fseqCurCmd(Object[] args) {
    }

    public List<TUIOCursor> getCursorList() {
        return this.cursors;
    }

    protected TUIOCursor createNewCursor(float x, float y, long id) {
        return new TUIOCursor(x, y, id);
    }
}

