/*
 * Decompiled with CFR 0.152.
 */
package org.cbook.cbookif;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cbook.cbookif.CBookEvent;
import org.cbook.cbookif.CBookEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBookEventHandler {
    private Object source;
    private Map<String, Set<CBookEventListener>> listeners;

    public CBookEventHandler(Object object) {
        this.source = object;
        this.listeners = new HashMap<String, Set<CBookEventListener>>();
    }

    public void addCBookEventListener(CBookEventListener cBookEventListener, String string) {
        Set<CBookEventListener> set = this.listeners.get(string);
        if (set == null) {
            set = new HashSet<CBookEventListener>();
            this.listeners.put(string, set);
        }
        if (cBookEventListener != null) {
            set.add(cBookEventListener);
        }
    }

    public void removeCBookEventListener(CBookEventListener cBookEventListener, String string) {
        Set<CBookEventListener> set = this.listeners.get(string);
        if (set == null) {
            return;
        }
        set.remove(cBookEventListener);
    }

    public void fire(CBookEvent cBookEvent) {
        HashSet<CBookEventListener> hashSet = new HashSet<CBookEventListener>();
        Set<CBookEventListener> set = this.listeners.get(cBookEvent.getCommand());
        if (set != null) {
            hashSet.addAll(set);
        }
        if ((set = this.listeners.get(null)) != null) {
            hashSet.addAll(set);
        }
        for (CBookEventListener cBookEventListener : hashSet) {
            cBookEventListener.acceptCBookEvent(cBookEvent);
        }
    }

    public void fire(String string) {
        this.fire(new CBookEvent(this.source, string));
    }

    public void fire(String string, Map<String, ?> map) {
        this.fire(new CBookEvent(this.source, string, map));
    }

    public void fire(String string, String string2, Object object) {
        Map<String, Object> map = Collections.singletonMap(string2, object);
        this.fire(string, map);
    }

    public void fire(String string, String string2) {
        this.fire(new CBookEvent(this.source, string, string2));
    }
}

