/*
 * Decompiled with CFR 0.152.
 */
package com.leapmotion.leap;

import com.leapmotion.leap.Interface;
import com.leapmotion.leap.LeapJNI;
import com.leapmotion.leap.Vector;

public class Device
extends Interface {
    private long swigCPtr;

    public Device(long l, boolean bl) {
        super(LeapJNI.Device_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    public static long getCPtr(Device device) {
        return device == null ? 0L : device.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LeapJNI.delete_Device(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Device() {
        this(LeapJNI.new_Device(), true);
    }

    public float horizontalViewAngle() {
        return LeapJNI.Device_horizontalViewAngle(this.swigCPtr, this);
    }

    public float verticalViewAngle() {
        return LeapJNI.Device_verticalViewAngle(this.swigCPtr, this);
    }

    public float range() {
        return LeapJNI.Device_range(this.swigCPtr, this);
    }

    public float distanceToBoundary(Vector vector) {
        return LeapJNI.Device_distanceToBoundary(this.swigCPtr, this, Vector.getCPtr(vector), vector);
    }

    public boolean isEmbedded() {
        return LeapJNI.Device_isEmbedded(this.swigCPtr, this);
    }

    public boolean isStreaming() {
        return LeapJNI.Device_isStreaming(this.swigCPtr, this);
    }

    public Type type() {
        return Type.swigToEnum(LeapJNI.Device_type(this.swigCPtr, this));
    }

    public boolean isValid() {
        return LeapJNI.Device_isValid(this.swigCPtr, this);
    }

    public static Device invalid() {
        return new Device(LeapJNI.Device_invalid(), false);
    }

    public boolean equals(Device device) {
        return LeapJNI.Device_equals(this.swigCPtr, this, Device.getCPtr(device), device);
    }

    public String toString() {
        return LeapJNI.Device_toString(this.swigCPtr, this);
    }

    public static enum Type {
        TYPE_PERIPHERAL(1),
        TYPE_LAPTOP,
        TYPE_KEYBOARD;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int n) {
            Type[] typeArray = (Type[])Type.class.getEnumConstants();
            if (n < typeArray.length && n >= 0 && typeArray[n].swigValue == n) {
                return typeArray[n];
            }
            for (Type type : typeArray) {
                if (type.swigValue != n) continue;
                return type;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + n);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private Type(Type type) {
            this.swigValue = type.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

