/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.reitinge.test;

import de.tum.in.cindy3dplugin.AppearanceState;
import de.tum.in.cindy3dplugin.Cindy3DViewer;
import de.tum.in.cindy3dplugin.LightModificationInfo;
import de.tum.in.cindy3dplugin.jogl.JOGLViewer;
import java.awt.Color;
import java.util.Hashtable;

public class JOGLViewerTest {
    public static void main(String[] args) {
        JOGLViewer viewer = new JOGLViewer();
        Hashtable<String, Object> hintsMap = new Hashtable<String, Object>();
        hintsMap.put("quality", 4.0);
        viewer.setRenderHints(hintsMap);
        viewer.begin();
        JOGLViewerTest.lights(viewer);
        viewer.end();
    }

    public static void materials(Cindy3DViewer viewer) {
        AppearanceState app = new AppearanceState(Color.red, 0.0, 1.0, 1.0);
        app.setAlpha(1.0);
        for (int i = 1; i <= 12; ++i) {
            for (int j = 1; j <= 12; ++j) {
                app.setShininess(i * 10);
                app.setColor(new Color(Color.HSBtoRGB((float)j / 12.0f, 1.0f, 1.0f)));
                viewer.addSphere(i - 6, j - 6, 0.0, 0.45, app);
            }
        }
    }

    public static void lights(Cindy3DViewer viewer) {
        AppearanceState appearance = new AppearanceState(Color.white, 60.0, 1.0, 1.0);
        viewer.addSphere(0.0, 0.0, 0.0, 3.0, appearance);
        LightModificationInfo info = new LightModificationInfo(LightModificationInfo.LightType.SPOT_LIGHT);
        info.setPosition(new double[]{0.0, 0.0, 0.0});
        info.setDirection(new double[]{0.0, 0.0, -1.0});
        info.setSpecular(Color.black);
        info.setCutoffAngle(20.0);
        info.setSpotExponent(2.0);
        info.setFrame(LightModificationInfo.LightFrame.CAMERA);
        viewer.setLight(0, info);
        appearance.setColor(Color.green);
        appearance.setAlpha(1.0);
        viewer.addSphere(-3.0, 0.0, 0.0, 1.5, appearance);
    }

    public static void enneper(Cindy3DViewer viewer, boolean dots) {
        AppearanceState app = new AppearanceState(Color.white, 60.0, 1.0, 1.0);
        viewer.setBackgroundColor(Color.black);
        int rr = 30;
        int ss = 30;
        double[][] vertices = new double[(2 * rr + 1) * (2 * ss + 1)][3];
        int i = 0;
        for (int ii = -rr; ii <= rr; ++ii) {
            double u = (double)ii / 20.0;
            int jj = -ss;
            while (jj <= ss) {
                double v = (double)jj / 20.0;
                double x = u - u * u * u / 3.0 + u * v * v;
                double y = v - v * v * v / 3.0 + v * u * u;
                double z = u * u - v * v;
                vertices[i][0] = x;
                vertices[i][1] = y;
                vertices[i][2] = z;
                ++jj;
                ++i;
            }
        }
        if (dots) {
            app.setSize(0.6);
            app.setColor(new Color(0.9f, 0.1f, 0.1f));
            for (double[] vertex : vertices) {
                viewer.addPoint(vertex[0], vertex[1], vertex[2], app);
            }
        }
        app.setAlpha(0.8);
        app.setColor(new Color(0.5f, 0.5f, 1.0f));
        viewer.addMesh(2 * rr + 1, 2 * ss + 1, vertices, Cindy3DViewer.NormalType.PER_VERTEX, Cindy3DViewer.MeshTopology.OPEN, app);
    }

    public static void colorSpiral(Cindy3DViewer viewer) {
        AppearanceState appearance = new AppearanceState(Color.red, 60.0, 1.0, 1.0);
        double height = 2.0;
        double radius = 1.0;
        int segments = 100;
        int rings = 20;
        for (int segment = 1; segment <= segments; ++segment) {
            double frac = (double)segment / (double)segments;
            appearance.setColor(new Color(Color.HSBtoRGB((float)frac, 1.0f, 1.0f)));
            for (int ring = 1; ring <= rings; ++ring) {
                double rad = (double)ring / (double)rings * radius;
                viewer.addPoint(Math.cos(frac * 2.0 * Math.PI) * rad, Math.sin(frac * 2.0 * Math.PI) * rad, (frac - 0.5) * height, appearance);
            }
        }
    }

    public static void circles(Cindy3DViewer viewer) {
        AppearanceState appearance = new AppearanceState(Color.red, 50.0, 1.0, 1.0);
        LightModificationInfo info = new LightModificationInfo(LightModificationInfo.LightType.DIRECTIONAL_LIGHT);
        info.setPosition(new double[]{10.0, 0.0, 0.0});
        info.setDirection(new double[]{1.0, 0.0, 0.0});
        viewer.setLight(0, info);
        info.setPosition(new double[]{0.0, 10.0, 0.0});
        info.setDirection(new double[]{0.0, 1.0, 0.0});
        viewer.setLight(1, info);
        info.setPosition(new double[]{0.0, 0.0, 10.0});
        info.setDirection(new double[]{0.0, 0.0, 1.0});
        viewer.setLight(2, info);
        for (int i = -5; i <= 5; ++i) {
            for (int j = -5; j <= 5; ++j) {
                appearance.setColor(Color.red);
                viewer.addCircle(i * 2, j * 2, 0.0, 1.0, 0.0, 0.0, 1.0, appearance);
                appearance.setColor(Color.green);
                viewer.addCircle(i * 2, j * 2, 0.0, 0.0, 1.0, 0.0, 1.0, appearance);
                appearance.setColor(Color.blue);
                viewer.addCircle(i * 2, j * 2, 0.0, 0.0, 0.0, 1.0, 1.0, appearance);
            }
        }
    }

    public static void spheres(Cindy3DViewer viewer) {
        AppearanceState appearance = new AppearanceState(Color.red, 60.0, 1.0, 1.0);
        viewer.addPoint(0.0, 0.0, 0.0, appearance);
        appearance.setColor(Color.blue);
        viewer.addPoint(2.0, 0.0, 0.0, appearance);
        int rings = 10;
        int segments = 20;
        double[][] vert = new double[rings * segments][3];
        for (int i = 0; i < rings; ++i) {
            double u = (double)(i * 2) * Math.PI / (double)rings;
            for (int j = 0; j < segments; ++j) {
                double v = (double)(j * 2) * Math.PI / (double)segments;
                double z = Math.cos(v) * 0.25;
                double x = Math.sin(v) * 0.25 + 1.0;
                double y = Math.sin(u) * x;
                vert[i * segments + j][0] = x *= Math.cos(u);
                vert[i * segments + j][1] = y;
                vert[i * segments + j][2] = z;
            }
        }
        appearance.setColor(Color.RED);
        viewer.addMesh(rings, segments, vert, Cindy3DViewer.NormalType.PER_VERTEX, Cindy3DViewer.MeshTopology.CLOSE_BOTH, appearance);
    }

    public static void lines(Cindy3DViewer viewer) {
        AppearanceState appearance = new AppearanceState(Color.red, 60.0, 1.0, 1.0);
        viewer.addSegment(-2.0, 0.0, 0.0, 2.0, 0.0, 0.0, appearance);
    }

    public static void icosahedron(JOGLViewer viewer) {
        int i;
        double[][] v;
        double[] vert2;
        double[] vert1;
        int[][] edges;
        AppearanceState appearance = new AppearanceState(Color.yellow, 60.0, 1.0, 1.0);
        double golden = (1.0 + Math.sqrt(5.0)) / 2.0;
        double[][] verts = new double[][]{{0.0, 1.0, golden}, {0.0, -1.0, golden}, {0.0, 1.0, -golden}, {0.0, -1.0, -golden}, {golden, 0.0, 1.0}, {golden, 0.0, -1.0}, {-golden, 0.0, 1.0}, {-golden, 0.0, -1.0}, {1.0, golden, 0.0}, {-1.0, golden, 0.0}, {1.0, -golden, 0.0}, {-1.0, -golden, 0.0}};
        for (int[] edge : edges = new int[][]{{0, 1}, {0, 4}, {0, 6}, {0, 8}, {0, 9}, {1, 4}, {1, 6}, {1, 10}, {1, 11}, {2, 3}, {2, 5}, {2, 7}, {2, 8}, {2, 9}, {3, 5}, {3, 7}, {3, 10}, {3, 11}, {4, 5}, {4, 8}, {4, 10}, {5, 8}, {5, 10}, {6, 7}, {6, 9}, {6, 11}, {7, 9}, {7, 11}, {8, 9}, {10, 11}}) {
            vert1 = verts[edge[0]];
            vert2 = verts[edge[1]];
            viewer.addSegment(vert1[0], vert1[1], vert1[2], vert2[0], vert2[1], vert2[2], appearance);
        }
        for (int[] edge : edges) {
            vert1 = verts[edge[0]];
            vert2 = verts[edge[1]];
            viewer.addSegment(2.0 * vert1[0], 2.0 * vert1[1], 2.0 * vert1[2], 2.0 * vert2[0], 2.0 * vert2[1], 2.0 * vert2[2], appearance);
        }
        int[][] triangles = new int[][]{{0, 1, 4}, {0, 1, 6}, {0, 4, 8}, {0, 6, 9}, {0, 8, 9}, {1, 4, 10}, {1, 6, 11}, {1, 10, 11}, {2, 3, 5}, {2, 3, 7}, {2, 5, 8}, {2, 7, 9}, {2, 8, 9}, {3, 5, 10}, {3, 7, 11}, {3, 10, 11}, {4, 5, 8}, {4, 5, 10}, {6, 7, 9}, {6, 7, 11}};
        Color[] col = new Color[]{Color.RED, Color.BLUE, Color.GREEN, Color.MAGENTA, Color.CYAN, Color.WHITE, Color.WHITE};
        appearance.setColor(Color.RED);
        int h = 0;
        for (int[] triangle : triangles) {
            v = new double[3][3];
            for (i = 0; i < 3; ++i) {
                v[i] = verts[triangle[i]];
            }
            appearance.setColor(col[h++ % col.length]);
            viewer.addPolygon(v, null, appearance);
        }
        appearance.setColor(Color.BLUE);
        h = 3;
        for (int[] triangle : triangles) {
            v = new double[3][3];
            for (i = 0; i < 3; ++i) {
                v[i] = (double[])verts[triangle[i]].clone();
                int j = 0;
                while (j < 3) {
                    double[] dArray = v[i];
                    int n = j++;
                    dArray[n] = dArray[n] * 2.0;
                }
            }
            appearance.setColor(col[h++ % col.length]);
            viewer.addPolygon(v, null, appearance);
        }
    }
}

