/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.renderers;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import de.tum.in.cindy3dplugin.jogl.ModelViewerCamera;
import de.tum.in.cindy3dplugin.jogl.RenderHints;
import de.tum.in.cindy3dplugin.jogl.Util;
import de.tum.in.cindy3dplugin.jogl.lighting.LightManager;
import de.tum.in.cindy3dplugin.jogl.primitives.Scene;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.PrimitiveRendererFactory;
import de.tum.in.cindy3dplugin.jogl.renderers.DefaultRenderer;

public class SupersampledRenderer
extends DefaultRenderer {
    private int width;
    private int height;
    private int requestedSuperSampleFactor = 2;
    private int superSampleFactor;
    private int colorTexture = 0;
    private int depthBuffer = 0;
    private int framebuffer = 0;

    public SupersampledRenderer(RenderHints renderHints, Scene scene, ModelViewerCamera camera, LightManager lightManager, PrimitiveRendererFactory prf) {
        super(renderHints, scene, camera, lightManager, prf);
        this.requestedSuperSampleFactor = renderHints.getSamplingRate();
        this.height = 1;
        this.width = 1;
    }

    public int getSuperSampleFactor() {
        return this.superSampleFactor;
    }

    private boolean createFramebuffer(GLAutoDrawable drawable, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        int[] textures = new int[1];
        gl.glGenTextures(1, textures, 0);
        gl.glBindTexture(3553, textures[0]);
        gl.glTexParameteri(3553, 33169, 1);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glTexParameteri(3553, 10241, 9987);
        gl.glTexImage2D(3553, 0, 6407, width, height, 0, 6407, 5121, null);
        this.colorTexture = textures[0];
        int[] renderbuffers = new int[1];
        gl.glGenRenderbuffers(1, renderbuffers, 0);
        gl.glBindRenderbuffer(36161, renderbuffers[0]);
        gl.glRenderbufferStorage(36161, 6402, width, height);
        gl.glBindRenderbuffer(36161, 0);
        this.depthBuffer = renderbuffers[0];
        int[] framebuffers = new int[1];
        gl.glGenFramebuffers(1, framebuffers, 0);
        gl.glBindFramebuffer(36160, framebuffers[0]);
        gl.glFramebufferTexture2D(36160, 36064, 3553, this.colorTexture, 0);
        gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.depthBuffer);
        int status = gl.glCheckFramebufferStatus(36160);
        if (status != 36053) {
            Util.getLogger().info("Framebuffer creation failed.");
            this.destroyFramebuffer(drawable);
            return false;
        }
        gl.glBindFramebuffer(36160, 0);
        this.framebuffer = framebuffers[0];
        return true;
    }

    private void destroyFramebuffer(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        int[] textures = new int[]{this.colorTexture};
        gl.glDeleteTextures(1, textures, 0);
        this.colorTexture = 0;
        int[] renderbuffers = new int[]{this.depthBuffer};
        gl.glDeleteRenderbuffers(1, renderbuffers, 0);
        this.depthBuffer = 0;
        int[] framebuffers = new int[]{this.framebuffer};
        gl.glDeleteFramebuffers(1, framebuffers, 0);
        this.framebuffer = 0;
    }

    @Override
    public void dispose(GLAutoDrawable drawable) {
        this.destroyFramebuffer(drawable);
        super.dispose(drawable);
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        if (this.framebuffer == 0) {
            this.createFramebuffer(drawable, this.width, this.height);
        }
        gl.glBindFramebuffer(36160, this.framebuffer);
        gl.glViewport(0, 0, this.width * this.superSampleFactor, this.height * this.superSampleFactor);
        super.display(drawable);
        gl.glBindFramebuffer(36160, 0);
        gl.glViewport(0, 0, this.width, this.height);
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glDisable(2896);
        gl.glDisable(2929);
        gl.glEnable(3553);
        gl.glBindTexture(3553, this.colorTexture);
        gl.glGenerateMipmap(3553);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex3d(-1.0, -1.0, 0.0);
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex3d(1.0, -1.0, 0.0);
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex3d(1.0, 1.0, 0.0);
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex3d(-1.0, 1.0, 0.0);
        gl.glEnd();
        gl.glDisable(3553);
        gl.glEnable(2896);
        gl.glEnable(2929);
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        this.superSampleFactor = this.requestedSuperSampleFactor;
        if (this.framebuffer != 0) {
            this.destroyFramebuffer(drawable);
        }
        while (!this.createFramebuffer(drawable, width * this.superSampleFactor, height * this.superSampleFactor) && this.superSampleFactor > 1) {
            --this.superSampleFactor;
        }
        super.reshape(drawable, x, y, width, height);
    }
}

