/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.renderers;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLException;
import de.tum.in.cindy3dplugin.jogl.ModelViewerCamera;
import de.tum.in.cindy3dplugin.jogl.RenderHints;
import de.tum.in.cindy3dplugin.jogl.Util;
import de.tum.in.cindy3dplugin.jogl.lighting.LightManager;
import de.tum.in.cindy3dplugin.jogl.primitives.Circle;
import de.tum.in.cindy3dplugin.jogl.primitives.Line;
import de.tum.in.cindy3dplugin.jogl.primitives.Mesh;
import de.tum.in.cindy3dplugin.jogl.primitives.Polygon;
import de.tum.in.cindy3dplugin.jogl.primitives.Scene;
import de.tum.in.cindy3dplugin.jogl.primitives.Sphere;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.PrimitiveRenderer;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.PrimitiveRendererFactory;
import de.tum.in.cindy3dplugin.jogl.renderers.JOGLRenderState;
import de.tum.in.cindy3dplugin.jogl.renderers.JOGLRenderer;
import java.util.logging.Level;

public class DefaultRenderer
extends JOGLRenderer {
    private PrimitiveRenderer<Sphere> sphereRenderer;
    private PrimitiveRenderer<Circle> circleRenderer;
    private PrimitiveRenderer<Line> lineRenderer;
    private PrimitiveRenderer<Polygon> polygonRenderer;
    private PrimitiveRenderer<Mesh> meshRenderer;

    public DefaultRenderer(RenderHints renderHints, Scene scene, ModelViewerCamera camera, LightManager lightManager, PrimitiveRendererFactory prf) {
        super(renderHints, scene, camera, lightManager);
        this.sphereRenderer = prf.createSphereRenderer();
        this.circleRenderer = prf.createCircleRenderer();
        this.lineRenderer = prf.createLineRenderer();
        this.polygonRenderer = prf.createPolygonRenderer();
        this.meshRenderer = prf.createMeshRenderer();
    }

    public void init(GLAutoDrawable drawable) {
        Util.getLogger().info("init()");
        try {
            GL2 gl = drawable.getGL().getGL2();
            Util.getLogger().info("Chosen caps: " + drawable.getChosenGLCapabilities());
            Util.getLogger().info("GL_VENDOR: " + gl.glGetString(7936));
            Util.getLogger().info("GL_RENDERER: " + gl.glGetString(7937));
            Util.getLogger().info("GL_VERSION: " + gl.glGetString(7938));
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            gl.glEnable(2929);
            gl.glDepthFunc(515);
            gl.glBlendFunc(770, 771);
            gl.glMaterialfv(1032, 4610, new float[]{0.5f, 0.5f, 0.5f, 0.5f}, 0);
            gl.glMaterialfv(1032, 4608, new float[]{0.2f, 0.2f, 0.2f, 0.2f}, 0);
            gl.glMaterialf(1032, 5633, 60.0f);
            gl.glLightModeli(2898, 1);
            gl.glEnable(2896);
            if (!this.sphereRenderer.init((GL)gl)) {
                Util.getLogger().severe("Point renderer initialization failed");
            }
            if (!this.circleRenderer.init((GL)gl)) {
                Util.getLogger().severe("Circle renderer initialization failed");
            }
            if (!this.lineRenderer.init((GL)gl)) {
                Util.getLogger().severe("Line renderer initialization failed");
            }
            if (!this.polygonRenderer.init((GL)gl)) {
                Util.getLogger().severe("Polygon renderer initialization failed");
            }
            if (!this.meshRenderer.init((GL)gl)) {
                Util.getLogger().severe("Mesh renderer initialization failed");
            }
        }
        catch (GLException e) {
            Util.getLogger().log(Level.SEVERE, e.toString(), e);
        }
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        Util.getLogger().info("reshape(" + x + "," + y + "," + width + "," + height + ")");
        GL2 gl = drawable.getGL().getGL2();
        this.camera.setPerspective(this.camera.getFieldOfView(), width, height, this.camera.getZNear(), this.camera.getZFar());
        gl.glMatrixMode(5889);
        gl.glLoadMatrixf(Util.matrixToFloatArrayTransposed(this.camera.getPerspectiveTransform()), 0);
        this.display(drawable);
    }

    private void renderPrimitives(JOGLRenderState jrs) {
        if (!jrs.renderOpaque()) {
            jrs.setCullMode(JOGLRenderState.CullMode.CULL_FRONT);
            this.sphereRenderer.render(jrs, this.scene.getSpheres());
            jrs.setCullMode(JOGLRenderState.CullMode.CULL_NONE);
        }
        this.circleRenderer.render(jrs, this.scene.getCircles());
        this.lineRenderer.render(jrs, this.scene.getLines());
        this.polygonRenderer.render(jrs, this.scene.getPolygons());
        this.meshRenderer.render(jrs, this.scene.getMeshes());
        jrs.setCullMode(JOGLRenderState.CullMode.CULL_BACK);
        this.sphereRenderer.render(jrs, this.scene.getSpheres());
        jrs.setCullMode(JOGLRenderState.CullMode.CULL_NONE);
    }

    public void display(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        float[] backgroundColor = new float[4];
        this.scene.getBackgroundColor().getRGBComponents(backgroundColor);
        gl.glClearColor(backgroundColor[0], backgroundColor[1], backgroundColor[2], backgroundColor[3]);
        gl.glClear(16640);
        gl.glMatrixMode(5888);
        gl.glLoadMatrixf(Util.matrixToFloatArrayTransposed(this.camera.getTransform()), 0);
        JOGLRenderState jrs = new JOGLRenderState((GL)gl, this.camera, true, JOGLRenderState.CullMode.CULL_NONE, this.renderHints);
        if (this.lightManager.hasLightSettingChanged()) {
            Util.setShaderLightFillIn(this.lightManager.getShaderFillIn());
            if (!this.sphereRenderer.reloadShaders((GL)gl)) {
                Util.getLogger().severe("Point renderer shader loading failed");
            }
            if (!this.circleRenderer.reloadShaders((GL)gl)) {
                Util.getLogger().severe("Circle renderer shader loading failed");
            }
            if (!this.lineRenderer.reloadShaders((GL)gl)) {
                Util.getLogger().severe("Line renderer shader loading failed");
            }
            if (!this.polygonRenderer.reloadShaders((GL)gl)) {
                Util.getLogger().severe("Polygon renderer shader loading failed");
            }
            if (!this.meshRenderer.reloadShaders((GL)gl)) {
                Util.getLogger().severe("Mesh renderer shader loading failed");
            }
            this.lightManager.resetLightSettingChanged();
        }
        this.lightManager.setGLState(gl);
        gl.glEnable(3042);
        gl.glDepthMask(false);
        jrs.setRenderOpaque(false);
        this.renderPrimitives(jrs);
        this.renderPrimitives(jrs);
        gl.glDepthMask(true);
        gl.glDisable(3042);
        jrs.setRenderOpaque(true);
        this.renderPrimitives(jrs);
        gl.glEnable(3042);
        jrs.setRenderOpaque(false);
        this.renderPrimitives(jrs);
        gl.glDisable(3042);
    }

    public void dispose(GLAutoDrawable drawable) {
        this.sphereRenderer.dispose(drawable.getGL());
        this.circleRenderer.dispose(drawable.getGL());
        this.lineRenderer.dispose(drawable.getGL());
        this.polygonRenderer.dispose(drawable.getGL());
        this.meshRenderer.dispose(drawable.getGL());
    }
}

