/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.primitives.renderers.shader;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import de.tum.in.cindy3dplugin.jogl.Util;
import de.tum.in.cindy3dplugin.jogl.primitives.Sphere;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.PrimitiveRenderer;
import de.tum.in.cindy3dplugin.jogl.renderers.JOGLRenderState;
import org.apache.commons.math.geometry.Vector3D;

public class SphereRenderer
extends PrimitiveRenderer<Sphere> {
    private ShaderProgram program = null;
    private int centerLoc;
    private int radiusLoc;
    private int modeLoc;
    private float renderMode;

    @Override
    public boolean init(GL gl) {
        return this.reloadShaders(gl);
    }

    @Override
    public boolean reloadShaders(GL gl) {
        GL2 gl2 = gl.getGL2();
        if (this.program != null) {
            this.program.destroy((GL2ES2)gl2);
        }
        this.program = Util.loadShaderProgram(gl2, "sphere.vert", "sphere.frag");
        if (this.program == null) {
            return false;
        }
        this.centerLoc = gl2.glGetUniformLocation(this.program.program(), "sphereCenter");
        this.radiusLoc = gl2.glGetUniformLocation(this.program.program(), "sphereRadius");
        this.modeLoc = gl2.glGetUniformLocation(this.program.program(), "sphereMode");
        return true;
    }

    @Override
    public void dispose(GL gl) {
        if (this.program != null) {
            this.program.destroy((GL2ES2)gl.getGL2());
        }
    }

    @Override
    protected void postRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glUseProgram(0);
    }

    @Override
    protected void preRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glUseProgram(this.program.program());
        if (jrs.getCullMode() == JOGLRenderState.CullMode.CULL_FRONT) {
            this.renderMode = 0.0f;
        } else if (jrs.getCullMode() == JOGLRenderState.CullMode.CULL_BACK) {
            this.renderMode = 1.0f;
        } else if (jrs.getCullMode() == JOGLRenderState.CullMode.CULL_NONE) {
            this.renderMode = 2.0f;
        }
    }

    @Override
    protected void render(JOGLRenderState jrs, Sphere sphere) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        Vector3D viewSpaceCenter = Util.transformPoint(jrs.getCamera().getTransform(), sphere.getCenter());
        gl2.glUniform3fv(this.centerLoc, 1, Util.vectorToFloatArray(viewSpaceCenter), 0);
        gl2.glUniform1f(this.radiusLoc, (float)sphere.getRadius());
        gl2.glUniform1f(this.modeLoc, this.renderMode);
        gl2.glBegin(7);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glVertex2f(1.0f, 1.0f);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glEnd();
    }
}

