/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.primitives.renderers.shader;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import de.tum.in.cindy3dplugin.jogl.Util;
import de.tum.in.cindy3dplugin.jogl.primitives.Polygon;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.PrimitiveRenderer;
import de.tum.in.cindy3dplugin.jogl.renderers.JOGLRenderState;

public class PolygonRenderer
extends PrimitiveRenderer<Polygon> {
    private ShaderProgram program = null;

    @Override
    public boolean init(GL gl) {
        return this.reloadShaders(gl);
    }

    @Override
    public boolean reloadShaders(GL gl) {
        GL2 gl2 = gl.getGL2();
        if (this.program != null) {
            this.program.destroy((GL2ES2)gl2);
        }
        this.program = Util.loadShaderProgram(gl2, "polygon.vert", "polygon.frag");
        return this.program != null;
    }

    @Override
    public void dispose(GL gl) {
        if (this.program != null) {
            this.program.destroy((GL2ES2)gl.getGL2());
        }
    }

    @Override
    protected void preRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glUseProgram(this.program.program());
    }

    @Override
    protected void render(JOGLRenderState jrs, Polygon polygon) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glBegin(9);
        for (int i = 0; i < polygon.getPositions().length; ++i) {
            gl2.glNormal3dv(Util.vectorToDoubleArray(polygon.getNormals()[i]), 0);
            gl2.glVertex3dv(Util.vectorToDoubleArray(polygon.getPositions()[i]), 0);
        }
        gl2.glEnd();
    }

    @Override
    protected void postRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glUseProgram(0);
    }
}

