/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.primitives.renderers.shader;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import de.tum.in.cindy3dplugin.jogl.Util;
import de.tum.in.cindy3dplugin.jogl.primitives.Line;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.LineRendererBase;
import de.tum.in.cindy3dplugin.jogl.renderers.JOGLRenderState;
import org.apache.commons.math.geometry.Vector3D;
import org.apache.commons.math.linear.RealMatrix;

public class LineRenderer
extends LineRendererBase {
    private ShaderProgram program = null;
    private int originLoc;
    private int directionLoc;
    private int radiusLoc;
    private int lengthLoc;

    @Override
    public boolean init(GL gl) {
        return this.reloadShaders(gl);
    }

    @Override
    public boolean reloadShaders(GL gl) {
        GL2 gl2 = gl.getGL2();
        if (this.program != null) {
            this.program.destroy((GL2ES2)gl2);
        }
        this.program = Util.loadShaderProgram(gl2, "cylinder.vert", "cylinder.frag");
        if (this.program == null) {
            return false;
        }
        this.originLoc = gl2.glGetUniformLocation(this.program.program(), "cylinderPoint");
        this.directionLoc = gl2.glGetUniformLocation(this.program.program(), "cylinderDirection");
        this.radiusLoc = gl2.glGetUniformLocation(this.program.program(), "cylinderRadius");
        this.lengthLoc = gl2.glGetUniformLocation(this.program.program(), "cylinderLength");
        return true;
    }

    @Override
    public void dispose(GL gl) {
        if (this.program != null) {
            this.program.destroy((GL2ES2)gl.getGL2());
        }
    }

    @Override
    protected void postRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glUseProgram(0);
    }

    @Override
    protected void preRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glUseProgram(this.program.program());
    }

    @Override
    protected void render(JOGLRenderState jrs, Line line) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        RealMatrix modelView = jrs.getCamera().getTransform();
        Vector3D p1 = Util.transformPoint(modelView, line.getFirstPoint());
        Vector3D p2 = Util.transformPoint(modelView, line.getSecondPoint());
        Vector3D direction = p2.subtract(p1);
        double cylinderLength = -1.0;
        switch (line.getLineType()) {
            case SEGMENT: {
                cylinderLength = direction.getNorm();
                break;
            }
            case RAY: {
                cylinderLength = 0.0;
                break;
            }
            case LINE: {
                cylinderLength = -1.0;
            }
        }
        direction = direction.normalize();
        LineRendererBase.Endpoints endPoints = LineRenderer.clipLineAtFrustum(jrs.getCamera(), p1, p2, line.getRadius(), line.getLineType());
        if (endPoints.p1.isNaN()) {
            return;
        }
        RealMatrix cylinder = LineRenderer.buildOBBTransform(endPoints, line.getRadius());
        gl2.glUniform1f(this.lengthLoc, (float)cylinderLength);
        gl2.glUniform1f(this.radiusLoc, (float)line.getRadius());
        gl2.glUniform3f(this.originLoc, (float)p1.getX(), (float)p1.getY(), (float)p1.getZ());
        gl2.glUniform3f(this.directionLoc, (float)direction.getX(), (float)direction.getY(), (float)direction.getZ());
        gl2.glMatrixMode(5888);
        gl2.glPushMatrix();
        gl2.glLoadTransposeMatrixf(Util.matrixToFloatArray(cylinder), 0);
        gl2.glBegin(7);
        gl2.glVertex3d(-1.0, -1.0, -1.0);
        gl2.glVertex3d(-1.0, -1.0, 1.0);
        gl2.glVertex3d(-1.0, 1.0, 1.0);
        gl2.glVertex3d(-1.0, 1.0, -1.0);
        gl2.glVertex3d(1.0, -1.0, 1.0);
        gl2.glVertex3d(1.0, -1.0, -1.0);
        gl2.glVertex3d(1.0, 1.0, -1.0);
        gl2.glVertex3d(1.0, 1.0, 1.0);
        gl2.glVertex3d(1.0, -1.0, 1.0);
        gl2.glVertex3d(-1.0, -1.0, 1.0);
        gl2.glVertex3d(-1.0, -1.0, -1.0);
        gl2.glVertex3d(1.0, -1.0, -1.0);
        gl2.glVertex3d(-1.0, 1.0, 1.0);
        gl2.glVertex3d(1.0, 1.0, 1.0);
        gl2.glVertex3d(1.0, 1.0, -1.0);
        gl2.glVertex3d(-1.0, 1.0, -1.0);
        gl2.glVertex3d(1.0, 1.0, 1.0);
        gl2.glVertex3d(-1.0, 1.0, 1.0);
        gl2.glVertex3d(-1.0, -1.0, 1.0);
        gl2.glVertex3d(1.0, -1.0, 1.0);
        gl2.glVertex3d(-1.0, -1.0, -1.0);
        gl2.glVertex3d(-1.0, 1.0, -1.0);
        gl2.glVertex3d(1.0, 1.0, -1.0);
        gl2.glVertex3d(1.0, -1.0, -1.0);
        gl2.glEnd();
        gl2.glPopMatrix();
    }
}

