/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.primitives.renderers.shader;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import de.tum.in.cindy3dplugin.jogl.Util;
import de.tum.in.cindy3dplugin.jogl.primitives.Circle;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.CircleRendererBase;
import de.tum.in.cindy3dplugin.jogl.renderers.JOGLRenderState;
import org.apache.commons.math.geometry.Vector3D;

public class CircleRenderer
extends CircleRendererBase {
    private ShaderProgram program = null;
    private int centerLoc;
    private int radiusSqLoc;
    private int normalLoc;

    @Override
    public boolean init(GL gl) {
        return this.reloadShaders(gl);
    }

    @Override
    public boolean reloadShaders(GL gl) {
        GL2 gl2 = gl.getGL2();
        if (this.program != null) {
            this.program.destroy((GL2ES2)gl2);
        }
        this.program = Util.loadShaderProgram(gl2, "circle.vert", "circle.frag");
        if (this.program == null) {
            return false;
        }
        this.centerLoc = gl2.glGetUniformLocation(this.program.program(), "circleCenter");
        this.radiusSqLoc = gl2.glGetUniformLocation(this.program.program(), "circleRadiusSq");
        this.normalLoc = gl2.glGetUniformLocation(this.program.program(), "circleNormal");
        return true;
    }

    @Override
    public void dispose(GL gl) {
        if (this.program != null) {
            this.program.destroy((GL2ES2)gl.getGL2());
        }
    }

    @Override
    protected void postRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glUseProgram(0);
    }

    @Override
    protected void preRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glUseProgram(this.program.program());
        gl2.glNormal3d(0.0, 0.0, 1.0);
    }

    @Override
    protected void render(JOGLRenderState jrs, Circle circle) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        Vector3D viewSpaceCenter = Util.transformPoint(jrs.getCamera().getTransform(), circle.getCenter());
        gl2.glUniform3fv(this.centerLoc, 1, Util.vectorToFloatArray(viewSpaceCenter), 0);
        gl2.glUniform3fv(this.normalLoc, 1, Util.vectorToFloatArray(circle.getNormal()), 0);
        gl2.glUniform1f(this.radiusSqLoc, (float)Math.pow(circle.getRadius(), 2.0));
        gl2.glMatrixMode(5888);
        gl2.glPushMatrix();
        gl2.glMultTransposeMatrixf(CircleRenderer.buildTransform(circle), 0);
        gl2.glBegin(7);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glVertex2f(1.0f, 1.0f);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glEnd();
        gl2.glPopMatrix();
    }
}

