/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.primitives.renderers.fixedfunc;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import de.tum.in.cindy3dplugin.jogl.Util;
import de.tum.in.cindy3dplugin.jogl.primitives.Sphere;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.PrimitiveRenderer;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.fixedfunc.LODMesh;
import de.tum.in.cindy3dplugin.jogl.renderers.JOGLRenderState;

public class SphereRenderer
extends PrimitiveRenderer<Sphere> {
    private static final int LOD_COUNT = 8;
    private LODMesh[] meshes = new LODMesh[8];

    private LODMesh createMesh(GL gl, int stacks, int slices) {
        int slice;
        int slice2;
        GL2 gl2 = gl.getGL2();
        int vertexCount = 2 + slices * (stacks - 1);
        int faceCount = 2 * slices + (stacks - 2) * slices * 2;
        LODMesh mesh = new LODMesh(3, vertexCount, faceCount, true);
        double[] vertex = new double[3];
        vertex[1] = 0.0;
        vertex[0] = 0.0;
        vertex[2] = -1.0;
        mesh.putVertex(vertex, vertex);
        for (int stack = 1; stack < stacks; ++stack) {
            double latitude = ((double)stack / (double)stacks - 0.5) * Math.PI;
            for (slice2 = 0; slice2 < slices; ++slice2) {
                double longitude = (double)slice2 / (double)slices * Math.PI * 2.0;
                vertex[0] = Math.cos(longitude) * Math.cos(latitude);
                vertex[1] = Math.sin(longitude) * Math.cos(latitude);
                vertex[2] = Math.sin(latitude);
                mesh.putVertex(vertex, vertex);
            }
        }
        vertex[1] = 0.0;
        vertex[0] = 0.0;
        vertex[2] = 1.0;
        mesh.putVertex(vertex, vertex);
        int stackOffset = 0;
        int nextStackOffset = 1;
        for (slice = 0; slice < slices; ++slice) {
            mesh.putFace(stackOffset, nextStackOffset + (slice + 1) % slices, nextStackOffset + slice);
        }
        for (int stack = 1; stack < stacks - 1; ++stack) {
            stackOffset = nextStackOffset;
            nextStackOffset += slices;
            for (slice2 = 0; slice2 < slices; ++slice2) {
                mesh.putFace(stackOffset + slice2, nextStackOffset + (slice2 + 1) % slices, nextStackOffset + slice2);
                mesh.putFace(stackOffset + slice2, stackOffset + (slice2 + 1) % slices, nextStackOffset + (slice2 + 1) % slices);
            }
        }
        for (slice = 0; slice < slices; ++slice) {
            mesh.putFace(nextStackOffset + slices, nextStackOffset + slice, nextStackOffset + (slice + 1) % slices);
        }
        mesh.finish(gl2);
        return mesh;
    }

    @Override
    public boolean init(GL gl) {
        for (int lod = 0; lod < 8; ++lod) {
            int stacks = lod + 2;
            int slices = 2 * stacks;
            this.meshes[lod] = this.createMesh(gl, stacks, slices);
        }
        return true;
    }

    @Override
    public void dispose(GL gl) {
        GL2 gl2 = gl.getGL2();
        for (LODMesh mesh : this.meshes) {
            mesh.dispose(gl2);
        }
    }

    @Override
    protected void preRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glEnable(2977);
        gl2.glEnableClientState(32884);
        gl2.glEnableClientState(32885);
        if (jrs.getCullMode() == JOGLRenderState.CullMode.CULL_FRONT) {
            gl2.glEnable(2884);
            gl2.glCullFace(1028);
        } else if (jrs.getCullMode() == JOGLRenderState.CullMode.CULL_BACK) {
            gl2.glEnable(2884);
            gl2.glCullFace(1029);
        }
    }

    @Override
    protected void postRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glDisable(2977);
        gl2.glDisableClientState(32884);
        gl2.glDisableClientState(32885);
    }

    @Override
    protected void render(JOGLRenderState jrs, Sphere sphere) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        double cameraSpaceZ = Util.transformPoint(jrs.getCamera().getTransform(), sphere.getCenter()).getZ() + sphere.getRadius();
        double allowedWorldSpaceError = jrs.getCamera().getWorldSpaceError(jrs.getRenderHints().getAllowedScreenSpaceError(), cameraSpaceZ);
        LODMesh mesh = this.meshes[7];
        for (int lod = 0; lod < 8; ++lod) {
            if (!this.meshes[lod].isSufficient(sphere.getRadius(), allowedWorldSpaceError)) continue;
            mesh = this.meshes[lod];
            break;
        }
        gl2.glMatrixMode(5888);
        gl2.glPushMatrix();
        gl2.glTranslated(sphere.getCenter().getX(), sphere.getCenter().getY(), sphere.getCenter().getZ());
        gl2.glScaled(sphere.getRadius(), sphere.getRadius(), sphere.getRadius());
        mesh.render(gl2);
        gl2.glPopMatrix();
    }
}

