/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.primitives.renderers.fixedfunc;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import de.tum.in.cindy3dplugin.jogl.Util;
import de.tum.in.cindy3dplugin.jogl.primitives.Line;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.LineRendererBase;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.fixedfunc.LODMesh;
import de.tum.in.cindy3dplugin.jogl.renderers.JOGLRenderState;
import org.apache.commons.math.geometry.Vector3D;
import org.apache.commons.math.linear.RealMatrix;

public class LineRenderer
extends LineRendererBase {
    private static final int LOD_COUNT = 8;
    private static final double LINE_LENGTH = 1.0;
    private LODMesh[] meshes = new LODMesh[8];

    private LODMesh createMesh(GL gl, int stacks, int slices) {
        int slice;
        GL2 gl2 = gl.getGL2();
        int vertexCount = (stacks + 1) * slices;
        int faceCount = 2 * stacks * slices;
        LODMesh mesh = new LODMesh(3, vertexCount, faceCount, true);
        double[] vertex = new double[3];
        for (int loop = 0; loop < stacks + 1; ++loop) {
            double zValue = 2.0 * ((double)loop / (double)stacks - 0.5);
            for (slice = 0; slice < slices; ++slice) {
                double angle = (double)slice / (double)slices * Math.PI * 2.0;
                vertex[0] = Math.cos(angle);
                vertex[1] = Math.sin(angle);
                vertex[2] = zValue;
                double[] normal = (double[])vertex.clone();
                normal[2] = 0.0;
                mesh.putVertex(vertex, normal);
            }
        }
        int loopOffset = 0;
        int nextLoopOffset = slices;
        for (int loop = 0; loop < stacks; ++loop) {
            for (slice = 0; slice < slices; ++slice) {
                mesh.putFace(loopOffset + slice, loopOffset + (slice + 1) % slices, nextLoopOffset + slice);
                mesh.putFace(nextLoopOffset + slice, loopOffset + (slice + 1) % slices, nextLoopOffset + (slice + 1) % slices);
            }
            loopOffset = nextLoopOffset;
            nextLoopOffset += slices;
        }
        mesh.finish(gl2);
        return mesh;
    }

    @Override
    public boolean init(GL gl) {
        for (int lod = 0; lod < 8; ++lod) {
            int slices = 4 * lod + 4;
            int loops = 4;
            this.meshes[lod] = this.createMesh(gl, loops, slices);
        }
        return true;
    }

    @Override
    public void dispose(GL gl) {
        GL2 gl2 = gl.getGL2();
        for (LODMesh mesh : this.meshes) {
            mesh.dispose(gl2);
        }
    }

    @Override
    protected void preRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glEnableClientState(32884);
        gl2.glEnableClientState(32885);
        gl2.glEnable(2977);
        gl2.glDisable(2884);
    }

    @Override
    protected void postRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glDisableClientState(32884);
        gl2.glDisableClientState(32885);
        gl2.glDisable(2977);
    }

    @Override
    protected void render(JOGLRenderState jrs, Line line) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        RealMatrix modelView = jrs.getCamera().getTransform();
        Vector3D p1 = Util.transformPoint(modelView, line.getFirstPoint());
        Vector3D p2 = Util.transformPoint(modelView, line.getSecondPoint());
        LineRendererBase.Endpoints endPoints = LineRenderer.clipLineAtFrustum(jrs.getCamera(), p1, p2, line.getRadius(), line.getLineType());
        if (endPoints.p1.isNaN()) {
            return;
        }
        double totalLength = Vector3D.distance((Vector3D)endPoints.p1, (Vector3D)endPoints.p2);
        int boxes = (int)Math.ceil(totalLength / 1.0);
        double boxLength = totalLength / (double)boxes;
        Vector3D direction = endPoints.p2.subtract(endPoints.p1).normalize().scalarMultiply(boxLength);
        endPoints.p2 = endPoints.p1.add(direction);
        RealMatrix cylinder = LineRenderer.buildOBBTransform(endPoints, line.getRadius());
        Vector3D boxMid = new Vector3D(0.5, endPoints.p1, 0.5, endPoints.p2);
        gl2.glMatrixMode(5888);
        gl2.glPushMatrix();
        for (int box = 0; box < boxes; ++box) {
            double allowedWorldSpaceError = jrs.getCamera().getWorldSpaceError(jrs.getRenderHints().getAllowedScreenSpaceError(), boxMid.getZ());
            LODMesh mesh = this.meshes[7];
            for (int lod = 0; lod < 8; ++lod) {
                if (!this.meshes[lod].isSufficient(line.getRadius(), allowedWorldSpaceError)) continue;
                mesh = this.meshes[lod];
                break;
            }
            gl2.glLoadIdentity();
            gl2.glTranslated((double)box * direction.getX(), (double)box * direction.getY(), (double)box * direction.getZ());
            gl2.glMultMatrixf(Util.matrixToFloatArrayTransposed(cylinder), 0);
            gl2.glRotated(90.0, 0.0, 1.0, 0.0);
            gl2.glScaled(1.0, 1.0, 1.0);
            mesh.render(gl2);
            boxMid = boxMid.add(direction);
        }
        gl2.glPopMatrix();
    }
}

