/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.primitives.renderers.fixedfunc;

import com.jogamp.opengl.GL2;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;

public class LODMesh {
    private int vertexBuffer;
    private int indexBuffer;
    private int faceCount;
    private int vertexPositionDimension;
    private double maxEdgeLength;
    private boolean hasNormals;
    private DoubleBuffer vertices;
    private IntBuffer indices;

    public LODMesh(int vertexPositionDimension, int vertexCount, int faceCount, boolean hasNormals) {
        this.vertexPositionDimension = vertexPositionDimension;
        this.faceCount = faceCount;
        this.hasNormals = hasNormals;
        this.vertices = hasNormals ? DoubleBuffer.allocate(vertexCount * (vertexPositionDimension + 3)) : DoubleBuffer.allocate(vertexCount * vertexPositionDimension);
        this.indices = IntBuffer.allocate(faceCount * 3);
        this.maxEdgeLength = 0.0;
    }

    public void putVertex(double[] position) {
        if (this.hasNormals) {
            throw new UnsupportedOperationException("Vertex normal expected.");
        }
        if (position.length != this.vertexPositionDimension) {
            throw new IllegalArgumentException("Wrong position dimension.");
        }
        this.vertices.put(position);
    }

    public void putVertex(double[] position, double[] normal) {
        if (!this.hasNormals) {
            throw new UnsupportedOperationException("Unexpected vertex normal.");
        }
        this.vertices.put(position);
        this.vertices.put(normal);
    }

    public void putFace(int i0, int i1, int i2) {
        this.indices.put(i0);
        this.indices.put(i1);
        this.indices.put(i2);
    }

    public void finish(GL2 gl) {
        int[] tmp = new int[2];
        gl.glGenBuffers(2, tmp, 0);
        this.vertexBuffer = tmp[0];
        this.indexBuffer = tmp[1];
        this.vertices.flip();
        gl.glBindBuffer(34962, this.vertexBuffer);
        gl.glBufferData(34962, (long)(this.vertices.capacity() * 8), (Buffer)this.vertices, 35044);
        gl.glBindBuffer(34962, 0);
        this.indices.flip();
        gl.glBindBuffer(34963, this.indexBuffer);
        gl.glBufferData(34963, (long)(this.indices.capacity() * 4), (Buffer)this.indices, 35044);
        gl.glBindBuffer(34963, 0);
        this.calculateMaxEdgeLength();
        this.vertices = null;
        this.indices = null;
    }

    private void calculateMaxEdgeLength() {
        this.maxEdgeLength = 0.0;
        int stride = this.vertexPositionDimension;
        if (this.hasNormals) {
            stride += 3;
        }
        for (int i = 0; i < this.indices.limit(); i += 3) {
            int i0 = this.indices.get(i);
            int i1 = this.indices.get(i + 1);
            int i2 = this.indices.get(i + 2);
            double[][] v = new double[3][this.vertexPositionDimension];
            this.vertices.position(i0 * stride);
            this.vertices.get(v[0], 0, this.vertexPositionDimension);
            this.vertices.position(i1 * stride);
            this.vertices.get(v[1], 0, this.vertexPositionDimension);
            this.vertices.position(i2 * stride);
            this.vertices.get(v[2], 0, this.vertexPositionDimension);
            for (int j = 0; j < 3; ++j) {
                double edgeLengthSq = 0.0;
                double[] v0 = v[j];
                double[] v1 = v[(j + 1) % 3];
                for (int k = 0; k < this.vertexPositionDimension; ++k) {
                    edgeLengthSq += Math.pow(v0[k] - v1[k], 2.0);
                }
                this.maxEdgeLength = Math.max(this.maxEdgeLength, Math.sqrt(edgeLengthSq));
            }
        }
    }

    public void dispose(GL2 gl2) {
        gl2.glDeleteBuffers(2, new int[]{this.vertexBuffer, this.indexBuffer}, 0);
    }

    public boolean isSufficient(double scale, double allowedWorldSpaceError) {
        double worldSpaceError = scale * this.maxEdgeLength;
        return worldSpaceError <= allowedWorldSpaceError;
    }

    public double getMaxEdgeLength() {
        return this.maxEdgeLength;
    }

    public void render(GL2 gl2) {
        gl2.glBindBuffer(34962, this.vertexBuffer);
        int stride = this.hasNormals ? 8 * (this.vertexPositionDimension + 3) : 8 * this.vertexPositionDimension;
        gl2.glVertexPointer(this.vertexPositionDimension, 5130, stride, 0L);
        if (this.hasNormals) {
            gl2.glNormalPointer(5130, stride, (long)(this.vertexPositionDimension * 8));
        }
        gl2.glBindBuffer(34963, this.indexBuffer);
        gl2.glDrawElements(4, this.faceCount * 3, 5125, 0L);
        gl2.glBindBuffer(34962, 0);
        gl2.glBindBuffer(34963, 0);
    }
}

