/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.primitives.renderers.fixedfunc;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import de.tum.in.cindy3dplugin.jogl.Util;
import de.tum.in.cindy3dplugin.jogl.primitives.Circle;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.CircleRendererBase;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.fixedfunc.LODMesh;
import de.tum.in.cindy3dplugin.jogl.renderers.JOGLRenderState;

public class CircleRenderer
extends CircleRendererBase {
    private static final int LOD_COUNT = 8;
    private LODMesh[] meshes = new LODMesh[8];

    private LODMesh createMesh(GL gl, int loops, int slices) {
        int slice;
        GL2 gl2 = gl.getGL2();
        int vertexCount = 1 + slices * loops;
        int faceCount = slices + (loops - 1) * slices * 2;
        LODMesh mesh = new LODMesh(2, vertexCount, faceCount, false);
        double[] vertex = new double[2];
        vertex[1] = 0.0;
        vertex[0] = 0.0;
        mesh.putVertex(vertex);
        for (int loop = 0; loop < loops; ++loop) {
            double radius = (double)(loop + 1) / (double)loops;
            for (slice = 0; slice < slices; ++slice) {
                double angle = (double)slice / (double)slices * Math.PI * 2.0;
                vertex[0] = Math.cos(angle) * radius;
                vertex[1] = Math.sin(angle) * radius;
                mesh.putVertex(vertex);
            }
        }
        int loopOffset = 0;
        int nextLoopOffset = 1;
        for (int slice2 = 0; slice2 < slices; ++slice2) {
            mesh.putFace(loopOffset, nextLoopOffset + slice2, nextLoopOffset + (slice2 + 1) % slices);
        }
        for (int loop = 1; loop < loops; ++loop) {
            loopOffset = nextLoopOffset;
            nextLoopOffset += slices;
            for (slice = 0; slice < slices; ++slice) {
                mesh.putFace(loopOffset + slice, nextLoopOffset + slice, nextLoopOffset + (slice + 1) % slices);
                mesh.putFace(loopOffset + slice, nextLoopOffset + (slice + 1) % slices, loopOffset + (slice + 1) % slices);
            }
        }
        mesh.finish(gl2);
        return mesh;
    }

    @Override
    public boolean init(GL gl) {
        for (int lod = 0; lod < 8; ++lod) {
            int loops = lod + 1;
            int slices = 4 * loops;
            this.meshes[lod] = this.createMesh(gl, loops, slices);
        }
        return true;
    }

    @Override
    public void dispose(GL gl) {
        GL2 gl2 = gl.getGL2();
        for (LODMesh mesh : this.meshes) {
            mesh.dispose(gl2);
        }
    }

    @Override
    protected void preRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glDisable(2884);
        gl2.glEnableClientState(32884);
        gl2.glNormal3d(0.0, 0.0, 1.0);
    }

    @Override
    protected void postRender(JOGLRenderState jrs) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        gl2.glDisableClientState(32884);
    }

    @Override
    protected void render(JOGLRenderState jrs, Circle circle) {
        GL2 gl2 = jrs.getGLHandle().getGL2();
        double cameraSpaceZ = Util.transformPoint(jrs.getCamera().getTransform(), circle.getCenter()).getZ() + circle.getRadius();
        double allowedWorldSpaceError = jrs.getCamera().getWorldSpaceError(jrs.getRenderHints().getAllowedScreenSpaceError(), cameraSpaceZ);
        LODMesh mesh = this.meshes[7];
        for (int lod = 0; lod < 8; ++lod) {
            if (!this.meshes[lod].isSufficient(circle.getRadius(), allowedWorldSpaceError)) continue;
            mesh = this.meshes[lod];
            break;
        }
        gl2.glMatrixMode(5888);
        gl2.glPushMatrix();
        gl2.glMultTransposeMatrixf(CircleRenderer.buildTransform(circle), 0);
        mesh.render(gl2);
        gl2.glPopMatrix();
    }
}

