/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.primitives.renderers;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import de.tum.in.cindy3dplugin.Cindy3DViewer;
import de.tum.in.cindy3dplugin.jogl.primitives.Mesh;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;

public class MeshBuffer {
    private int vertexBuffer;
    private int indexBuffer;
    private boolean hasIndexBuffer;
    private int indexCount;
    private int vertexCount;

    public MeshBuffer(GL gl, Mesh m) {
        this.createBuffers(gl, m);
    }

    private void createBuffers(GL gl, Mesh m) {
        double[][] positions = m.getPositions();
        double[][] normals = m.getNormals();
        if (m.getNormalType() == Cindy3DViewer.NormalType.PER_VERTEX) {
            this.vertexCount = m.getColumnCount() * m.getRowCount();
            this.indexCount = m.getFaceCount() * 3;
            this.hasIndexBuffer = true;
        } else {
            this.vertexCount = m.getFaceCount() * 3;
            this.indexCount = 0;
            this.hasIndexBuffer = false;
        }
        DoubleBuffer vertices = DoubleBuffer.allocate(this.vertexCount * 6);
        IntBuffer indices = null;
        if (m.getNormalType() == Cindy3DViewer.NormalType.PER_VERTEX) {
            indices = IntBuffer.allocate(this.indexCount);
            for (int i = 0; i < this.vertexCount; ++i) {
                vertices.put(positions[i]);
                vertices.put(normals[i]);
            }
        }
        int faceIndex = 0;
        for (int row = 0; row < m.getRowMax(); ++row) {
            for (int column = 0; column < m.getColumnMax(); ++column) {
                int rowPlus1 = (row + 1) % m.getRowCount();
                int columnPlus1 = (column + 1) % m.getColumnCount();
                int v1Index = m.getVertexIndex(row, column);
                int v2Index = m.getVertexIndex(row, columnPlus1);
                int v3Index = m.getVertexIndex(rowPlus1, column);
                int v4Index = m.getVertexIndex(rowPlus1, columnPlus1);
                if (m.getNormalType() == Cindy3DViewer.NormalType.PER_VERTEX) {
                    indices.put(v1Index);
                    indices.put(v2Index);
                    indices.put(v3Index);
                    indices.put(v2Index);
                    indices.put(v4Index);
                    indices.put(v3Index);
                    continue;
                }
                int f1Index = faceIndex++;
                vertices.put(positions[v1Index]);
                vertices.put(normals[f1Index]);
                vertices.put(positions[v2Index]);
                vertices.put(normals[f1Index]);
                vertices.put(positions[v3Index]);
                vertices.put(normals[f1Index]);
                int f2Index = faceIndex++;
                vertices.put(positions[v2Index]);
                vertices.put(normals[f2Index]);
                vertices.put(positions[v4Index]);
                vertices.put(normals[f2Index]);
                vertices.put(positions[v3Index]);
                vertices.put(normals[f2Index]);
            }
        }
        vertices.flip();
        int[] tmp = new int[1];
        gl.glGenBuffers(1, tmp, 0);
        this.vertexBuffer = tmp[0];
        gl.glBindBuffer(34962, this.vertexBuffer);
        gl.glBufferData(34962, (long)(vertices.capacity() * 8), (Buffer)vertices, 35044);
        gl.glBindBuffer(34962, 0);
        if (this.hasIndexBuffer) {
            indices.flip();
            gl.glGenBuffers(1, tmp, 0);
            this.indexBuffer = tmp[0];
            gl.glBindBuffer(34963, this.indexBuffer);
            gl.glBufferData(34963, (long)(indices.capacity() * 4), (Buffer)indices, 35044);
            gl.glBindBuffer(34963, 0);
        } else {
            this.indexBuffer = 0;
        }
    }

    public void render(GL gl) {
        GL2 gl2 = gl.getGL2();
        gl2.glBindBuffer(34962, this.vertexBuffer);
        gl2.glVertexPointer(3, 5130, 48, 0L);
        gl2.glNormalPointer(5130, 48, 24L);
        if (this.hasIndexBuffer) {
            gl2.glBindBuffer(34963, this.indexBuffer);
            gl2.glDrawElements(4, this.indexCount, 5125, 0L);
        } else {
            gl2.glDrawArrays(4, 0, this.vertexCount);
        }
    }

    public void dispose(GL2 gl) {
        gl.glDeleteBuffers(2, new int[]{this.vertexBuffer, this.indexBuffer}, 0);
    }
}

