/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.primitives.renderers;

import de.tum.in.cindy3dplugin.jogl.ModelViewerCamera;
import de.tum.in.cindy3dplugin.jogl.Plane;
import de.tum.in.cindy3dplugin.jogl.primitives.Line;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.PrimitiveRenderer;
import org.apache.commons.math.geometry.Rotation;
import org.apache.commons.math.geometry.Vector3D;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;

public abstract class LineRendererBase
extends PrimitiveRenderer<Line> {
    protected static Endpoints clipLineAtFrustum(ModelViewerCamera camera, Vector3D p1, Vector3D p2, double radius, Line.LineType lineType) {
        Vector3D direction = p2.subtract(p1).normalize();
        Plane[] planes = camera.getClippingPlanes();
        if (lineType != Line.LineType.SEGMENT) {
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            for (int i = 0; i < 6; ++i) {
                double lambda = planes[i].intersectRayWithShift(p1, direction, radius);
                if (lambda == Double.MAX_VALUE) continue;
                Vector3D p = p1.add(lambda, direction);
                boolean inFrustum = true;
                for (int j = 0; j < 6; ++j) {
                    if (j == i || !(planes[j].distance(p) > radius)) continue;
                    inFrustum = false;
                    break;
                }
                if (!inFrustum) continue;
                min = Math.min(min, lambda);
                max = Math.max(max, lambda);
            }
            if (min == Double.MAX_VALUE) {
                p1 = p2 = Vector3D.NaN;
            }
            p2 = new Vector3D(1.0, p1, max, direction);
            if (lineType == Line.LineType.LINE) {
                p1 = new Vector3D(1.0, p1, min, direction);
            }
        }
        return new Endpoints(p1, p2);
    }

    protected static RealMatrix buildOBBTransform(Endpoints endPoints, double radius) {
        double dist = 0.5 * Vector3D.distance((Vector3D)endPoints.p1, (Vector3D)endPoints.p2);
        Vector3D direction = endPoints.p2.subtract(endPoints.p1).normalize();
        Vector3D avg = new Vector3D(0.5, endPoints.p1, 0.5, endPoints.p2);
        RealMatrix translationMatrix = MatrixUtils.createRealIdentityMatrix((int)4);
        translationMatrix.setColumn(3, new double[]{avg.getX(), avg.getY(), avg.getZ(), 1.0});
        Rotation rotation = new Rotation(Vector3D.PLUS_I, direction);
        RealMatrix rotationMatrix = MatrixUtils.createRealIdentityMatrix((int)4);
        rotationMatrix.setSubMatrix(rotation.getMatrix(), 0, 0);
        RealMatrix scaleMatrix = MatrixUtils.createRealDiagonalMatrix((double[])new double[]{dist, radius, radius, 1.0});
        RealMatrix cylinder = translationMatrix.multiply(rotationMatrix).multiply(scaleMatrix);
        return cylinder;
    }

    protected static class Endpoints {
        public Vector3D p1;
        public Vector3D p2;

        public Endpoints(Vector3D p1, Vector3D p2) {
            this.p1 = p1;
            this.p2 = p2;
        }
    }
}

