/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.primitives;

import de.tum.in.cindy3dplugin.jogl.Material;
import de.tum.in.cindy3dplugin.jogl.primitives.Primitive;
import org.apache.commons.math.geometry.Vector3D;

public class Polygon
extends Primitive {
    private Vector3D[] positions;
    private Vector3D[] normals;

    public Polygon(double[][] positions, double[][] normals, Material material) {
        super(material);
        int i;
        this.positions = new Vector3D[positions.length];
        this.normals = new Vector3D[positions.length];
        for (i = 0; i < positions.length; ++i) {
            this.positions[i] = new Vector3D(positions[i][0], positions[i][1], positions[i][2]);
        }
        if (normals != null) {
            for (i = 0; i < positions.length; ++i) {
                this.normals[i] = new Vector3D(normals[i][0], normals[i][1], normals[i][2]);
            }
        } else {
            Vector3D v1 = this.positions[2].subtract(this.positions[0]);
            Vector3D v2 = this.positions[1].subtract(this.positions[0]);
            Vector3D normal = Vector3D.crossProduct((Vector3D)v2, (Vector3D)v1).normalize();
            for (int i2 = 0; i2 < this.normals.length; ++i2) {
                this.normals[i2] = normal;
            }
        }
    }

    public String toString() {
        Object str = "[";
        for (int i = 0; i < this.positions.length; ++i) {
            str = (String)str + this.positions[i].toString();
        }
        str = (String)str + "]";
        return str;
    }

    public Vector3D[] getPositions() {
        return this.positions;
    }

    public Vector3D[] getNormals() {
        return this.normals;
    }
}

