/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.primitives;

import de.tum.in.cindy3dplugin.Cindy3DViewer;
import de.tum.in.cindy3dplugin.jogl.Material;
import de.tum.in.cindy3dplugin.jogl.Util;
import de.tum.in.cindy3dplugin.jogl.primitives.Primitive;
import org.apache.commons.math.geometry.Vector3D;

public class Mesh
extends Primitive {
    private static int meshCounter = 0;
    private int rowCount;
    private int columnCount;
    private int columnMax;
    private int rowMax;
    private int faceCount;
    private double[][] positions;
    private double[][] normals;
    private Cindy3DViewer.NormalType normalType;
    private int identifier;
    private Cindy3DViewer.MeshTopology topology;

    public Mesh(int rowCount, int columnCount, double[][] positions, double[][] normals, Cindy3DViewer.MeshTopology topology, Material material) {
        super(material);
        this.init(rowCount, columnCount, positions, normals, Cindy3DViewer.NormalType.PER_VERTEX, topology);
    }

    public Mesh(int rowCount, int columnCount, double[][] positions, Cindy3DViewer.NormalType normalType, Cindy3DViewer.MeshTopology topology, Material material) {
        super(material);
        this.init(rowCount, columnCount, positions, null, normalType, topology);
        this.computeNormals();
    }

    private void init(int rowCount, int columnCount, double[][] positions, double[][] normals, Cindy3DViewer.NormalType normalType, Cindy3DViewer.MeshTopology topology) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.positions = positions;
        this.normals = normals;
        this.normalType = normalType;
        this.topology = topology;
        this.identifier = meshCounter++;
        switch (this.topology) {
            case OPEN: {
                this.columnMax = columnCount - 1;
                this.rowMax = rowCount - 1;
                break;
            }
            case CLOSE_ROWS: {
                this.columnMax = columnCount;
                this.rowMax = rowCount - 1;
                break;
            }
            case CLOSE_COLUMNS: {
                this.columnMax = columnCount - 1;
                this.rowMax = rowCount;
                break;
            }
            case CLOSE_BOTH: {
                this.columnMax = columnCount;
                this.rowMax = rowCount;
                break;
            }
            default: {
                return;
            }
        }
        this.faceCount = this.columnMax * this.rowMax * 2;
    }

    public double[][] getPositions() {
        return this.positions;
    }

    public double[][] getNormals() {
        return this.normals;
    }

    public Cindy3DViewer.NormalType getNormalType() {
        return this.normalType;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public int getFaceCount() {
        return this.faceCount;
    }

    public int getColumnMax() {
        return this.columnMax;
    }

    public int getRowMax() {
        return this.rowMax;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getVertexIndex(int row, int column) {
        return row * this.columnCount + column;
    }

    private void computeNormals() {
        block8: {
            int i;
            Vector3D[] faceNormals;
            block7: {
                this.normals = null;
                faceNormals = new Vector3D[this.faceCount];
                Vector3D[] vertexNormals = null;
                if (this.normalType == Cindy3DViewer.NormalType.PER_VERTEX) {
                    vertexNormals = new Vector3D[this.columnCount * this.rowCount];
                    for (int i2 = 0; i2 < vertexNormals.length; ++i2) {
                        vertexNormals[i2] = Vector3D.ZERO;
                    }
                }
                Vector3D[] positions = new Vector3D[this.columnCount * this.rowCount];
                for (int i3 = 0; i3 < positions.length; ++i3) {
                    positions[i3] = new Vector3D(this.positions[i3][0], this.positions[i3][1], this.positions[i3][2]);
                }
                int faceIndex = 0;
                for (int row = 0; row < this.rowMax; ++row) {
                    for (int column = 0; column < this.columnMax; ++column) {
                        int rowPlus1 = (row + 1) % this.rowCount;
                        int columnPlus1 = (column + 1) % this.columnCount;
                        int v1Index = this.getVertexIndex(row, column);
                        int v2Index = this.getVertexIndex(row, columnPlus1);
                        int v3Index = this.getVertexIndex(rowPlus1, column);
                        int v4Index = this.getVertexIndex(rowPlus1, columnPlus1);
                        Vector3D v1 = positions[v1Index];
                        Vector3D v2 = positions[v2Index];
                        Vector3D v3 = positions[v3Index];
                        Vector3D v4 = positions[v4Index];
                        int f1Index = faceIndex++;
                        int f2Index = faceIndex++;
                        faceNormals[f1Index] = Vector3D.crossProduct((Vector3D)v2.subtract(v1), (Vector3D)v3.subtract(v1)).normalize();
                        faceNormals[f2Index] = Vector3D.crossProduct((Vector3D)v3.subtract(v4), (Vector3D)v2.subtract(v4)).normalize();
                        if (this.normalType != Cindy3DViewer.NormalType.PER_VERTEX) continue;
                        vertexNormals[v1Index] = vertexNormals[v1Index].add(faceNormals[f1Index]);
                        vertexNormals[v2Index] = vertexNormals[v2Index].add(faceNormals[f1Index]).add(faceNormals[f2Index]);
                        vertexNormals[v3Index] = vertexNormals[v3Index].add(faceNormals[f1Index]).add(faceNormals[f2Index]);
                        vertexNormals[v4Index] = vertexNormals[v4Index].add(faceNormals[f2Index]);
                    }
                }
                if (this.normalType != Cindy3DViewer.NormalType.PER_VERTEX) break block7;
                this.normals = new double[this.columnCount * this.rowCount][3];
                for (i = 0; i < vertexNormals.length; ++i) {
                    this.normals[i] = Util.vectorToDoubleArray(vertexNormals[i].normalize());
                }
                break block8;
            }
            if (this.normalType != Cindy3DViewer.NormalType.PER_FACE) break block8;
            this.normals = new double[this.faceCount][3];
            for (i = 0; i < this.normals.length; ++i) {
                this.normals[i] = Util.vectorToDoubleArray(faceNormals[i]);
            }
        }
    }
}

