/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.lighting;

import com.jogamp.opengl.GL2;
import de.tum.in.cindy3dplugin.LightModificationInfo;
import de.tum.in.cindy3dplugin.jogl.lighting.Light;
import org.apache.commons.math.geometry.Vector3D;

public class SpotLight
extends Light {
    private Vector3D position = new Vector3D(0.0, 0.0, 0.0);
    private Vector3D direction = new Vector3D(0.0, -1.0, 0.0);
    private double cutoff = 45.0;
    private double exponent = 0.0;

    public void setPosition(Vector3D position) {
        this.position = position;
    }

    public void setDirection(Vector3D direction) {
        this.direction = direction;
    }

    public void setCutoffAngle(double cutoffAngle) {
        this.cutoff = Math.max(0.0, Math.min(cutoffAngle, 90.0));
    }

    public void setExponent(double exponent) {
        this.exponent = Math.max(0.0, Math.min(exponent, 128.0));
    }

    @Override
    public void setGLState(GL2 gl, int light) {
        super.setGLState(gl, light);
        if (this.frame == LightModificationInfo.LightFrame.CAMERA) {
            gl.glMatrixMode(5888);
            gl.glPushMatrix();
            gl.glLoadIdentity();
        }
        gl.glLightfv(light, 4611, new float[]{(float)this.position.getX(), (float)this.position.getY(), (float)this.position.getZ(), 1.0f}, 0);
        gl.glLightfv(light, 4612, new float[]{(float)this.direction.getX(), (float)this.direction.getY(), (float)this.direction.getZ()}, 0);
        gl.glLightf(light, 4614, (float)this.cutoff);
        gl.glLightf(light, 4613, (float)this.exponent);
        if (this.frame == LightModificationInfo.LightFrame.CAMERA) {
            gl.glPopMatrix();
        }
    }

    @Override
    public String getShaderFillIn(int light) {
        return "spotLight(position, normal, eye, " + light + ");";
    }

    @Override
    public LightModificationInfo.LightType getType() {
        return LightModificationInfo.LightType.SPOT_LIGHT;
    }
}

