/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl.lighting;

import com.jogamp.opengl.GL2;
import de.tum.in.cindy3dplugin.LightModificationInfo;
import de.tum.in.cindy3dplugin.jogl.Util;
import de.tum.in.cindy3dplugin.jogl.lighting.DirectionalLight;
import de.tum.in.cindy3dplugin.jogl.lighting.Light;
import de.tum.in.cindy3dplugin.jogl.lighting.PointLight;
import de.tum.in.cindy3dplugin.jogl.lighting.SpotLight;

public class LightManager {
    boolean lightSettingChanged = false;
    Light[] lights = new Light[8];

    public LightManager() {
        LightModificationInfo info = new LightModificationInfo(LightModificationInfo.LightType.POINT_LIGHT);
        info.setPosition(new double[]{0.0, 0.0, 0.0});
        this.setLight(0, info);
    }

    public void setLight(int light, LightModificationInfo info) {
        if (this.lights[light] == null || this.lights[light].getType() != info.getType()) {
            this.lightSettingChanged = true;
            switch (info.getType()) {
                case POINT_LIGHT: {
                    this.lights[light] = new PointLight();
                    break;
                }
                case DIRECTIONAL_LIGHT: {
                    this.lights[light] = new DirectionalLight();
                    break;
                }
                case SPOT_LIGHT: {
                    this.lights[light] = new SpotLight();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (!this.lights[light].isEnabled()) {
            this.lights[light].setEnabled(true);
            this.lightSettingChanged = true;
        }
        if (info.hasAmbient()) {
            this.lights[light].setAmbientColor(info.getAmbient());
        }
        if (info.hasDiffuse()) {
            this.lights[light].setDiffuseColor(info.getDiffuse());
        }
        if (info.hasSpecular()) {
            this.lights[light].setSpecularColor(info.getSpecular());
        }
        if (info.hasFrame()) {
            this.lights[light].setLightFrame(info.getFrame());
        }
        switch (info.getType()) {
            case POINT_LIGHT: {
                PointLight pointLight = (PointLight)this.lights[light];
                if (!info.hasPosition()) break;
                pointLight.setPosition(Util.doubleArrayToVector(info.getPosition()));
                break;
            }
            case DIRECTIONAL_LIGHT: {
                DirectionalLight directionalLight = (DirectionalLight)this.lights[light];
                if (!info.hasDirection()) break;
                directionalLight.setDirection(Util.doubleArrayToVector(info.getDirection()));
                break;
            }
            case SPOT_LIGHT: {
                SpotLight spotLight = (SpotLight)this.lights[light];
                if (info.hasPosition()) {
                    spotLight.setPosition(Util.doubleArrayToVector(info.getPosition()));
                }
                if (info.hasDirection()) {
                    spotLight.setDirection(Util.doubleArrayToVector(info.getDirection()));
                }
                if (info.hasCutoffAngle()) {
                    spotLight.setCutoffAngle(info.getCutoffAngle());
                }
                if (!info.hasSpotExponent()) break;
                spotLight.setExponent(info.getSpotExponent());
            }
        }
    }

    public String getShaderFillIn() {
        Object str = "vec3 eye = -normalize(position);\n";
        for (int i = 0; i < 8; ++i) {
            if (this.lights[i] == null || !this.lights[i].isEnabled()) continue;
            str = (String)str + this.lights[i].getShaderFillIn(i) + "\n";
        }
        return str;
    }

    public boolean hasLightSettingChanged() {
        return this.lightSettingChanged;
    }

    public void resetLightSettingChanged() {
        this.lightSettingChanged = false;
    }

    public void setGLState(GL2 gl) {
        gl.glLightModeli(2897, 1);
        for (int i = 0; i < 8; ++i) {
            if (this.lights[i] == null) continue;
            this.lights[i].setGLState(gl, 16384 + i);
        }
    }

    public void disableLight(int light) {
        if (!this.lights[light].isEnabled()) {
            return;
        }
        this.lights[light].setEnabled(false);
        this.lightSettingChanged = true;
    }
}

