/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.jvm.JNILibLoaderBase;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math.geometry.Vector3D;
import org.apache.commons.math.linear.RealMatrix;

public class Util {
    private static final String SHADER_PATH = "/de/tum/in/cindy3dplugin/resources/shader/";
    private static final boolean FILE_LOGGING = false;
    public static final int BYTES_PER_DOUBLE = 8;
    public static final int BYTES_PER_INT = 4;
    private static String shaderLightFillIn = "";
    private static Logger logger;

    private Util() {
        throw new UnsupportedOperationException();
    }

    public static float[] matrixToFloatArray(RealMatrix m) {
        int rows = m.getRowDimension();
        int cols = m.getColumnDimension();
        float[] result = new float[rows * cols];
        double[][] data = m.getData();
        int offset = 0;
        for (int row = 0; row < rows; ++row) {
            int col = 0;
            while (col < cols) {
                result[offset] = (float)data[row][col];
                ++col;
                ++offset;
            }
        }
        return result;
    }

    public static float[] matrixToFloatArrayTransposed(RealMatrix m) {
        int rows = m.getRowDimension();
        int cols = m.getColumnDimension();
        float[] result = new float[rows * cols];
        double[][] data = m.getData();
        int offset = 0;
        for (int row = 0; row < rows; ++row) {
            int col = 0;
            while (col < cols) {
                result[offset] = (float)data[col][row];
                ++col;
                ++offset;
            }
        }
        return result;
    }

    public static double[] vectorToDoubleArray(Vector3D v) {
        return new double[]{v.getX(), v.getY(), v.getZ()};
    }

    public static float[] vectorToFloatArray(Vector3D v) {
        return new float[]{(float)v.getX(), (float)v.getY(), (float)v.getZ()};
    }

    public static Vector3D doubleArrayToVector(double[] vec) {
        if (vec.length != 3) {
            return null;
        }
        return new Vector3D(vec[0], vec[1], vec[2]);
    }

    public static void readShaderSource(URL url, StringBuffer result) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#pragma include ")) {
                    String includeFile = line.substring(16).trim();
                    URL nextURL = null;
                    try {
                        nextURL = new URL(url, includeFile);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (nextURL == null) {
                        try {
                            nextURL = new URL(includeFile);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    if (nextURL == null) {
                        throw new FileNotFoundException("Can't find include file " + includeFile);
                    }
                    Util.readShaderSource(nextURL, result);
                    continue;
                }
                if (line.startsWith("#pragma lights")) {
                    result.append(shaderLightFillIn + "\n");
                    continue;
                }
                result.append(line + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ShaderCode loadShader(int type, String fileName) {
        StringBuffer buffer = new StringBuffer();
        URL url = Util.class.getResource(SHADER_PATH + fileName);
        Util.readShaderSource(url, buffer);
        ShaderCode shader = new ShaderCode(type, 1, (CharSequence[][])new String[][]{{buffer.toString()}});
        return shader;
    }

    public static ShaderProgram loadShaderProgram(GL2 gl2, String vertexShaderFileName, String fragmentShaderFileName) {
        ShaderProgram program = new ShaderProgram();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ShaderCode vertexShader = Util.loadShader(35633, vertexShaderFileName);
        if (!vertexShader.compile((GL2ES2)gl2, ps)) {
            Util.getLogger().info("Compile log for '" + vertexShaderFileName + "': " + baos.toString());
            return null;
        }
        ShaderCode fragmentShader = Util.loadShader(35632, fragmentShaderFileName);
        if (!fragmentShader.compile((GL2ES2)gl2, ps)) {
            Util.getLogger().info("Compile log for '" + fragmentShaderFileName + "': " + baos.toString());
            return null;
        }
        if (!program.add((GL2ES2)gl2, vertexShader, ps)) {
            Util.getLogger().info("Attach log for '" + vertexShaderFileName + "': " + baos.toString());
            return null;
        }
        if (!program.add((GL2ES2)gl2, fragmentShader, ps)) {
            Util.getLogger().info("Attach log for '" + fragmentShaderFileName + "': " + baos.toString());
            return null;
        }
        if (!program.link((GL2ES2)gl2, ps)) {
            Util.getLogger().info("Link log: " + baos.toString());
            return null;
        }
        return program;
    }

    public static void setShaderLightFillIn(String shaderLightFillIn) {
        Util.shaderLightFillIn = shaderLightFillIn;
    }

    public static void setupGluegenClassLoading() {
        String jarPath = null;
        URL jarURL = null;
        try {
            ProtectionDomain pd = Util.class.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            jarURL = cs.getLocation();
            jarPath = jarURL.getPath();
        }
        catch (SecurityException e) {
            Util.getLogger().log(Level.INFO, e.toString(), e);
            return;
        }
        File jarFile = new File(jarPath);
        if (!jarFile.isFile()) {
            Util.getLogger().info("Not loaded from jar");
            return;
        }
        final String basePath = jarFile.getParent();
        Util.getLogger().info("Base path: " + basePath);
        String path = basePath + File.separator + System.mapLibraryName("gluegen-rt");
        System.load(path);
        Util.getLogger().info("Loaded " + path);
        JNILibLoaderBase.setLoadingAction((JNILibLoaderBase.LoaderAction)new JNILibLoaderBase.LoaderAction(){

            public void loadLibrary(String libname, String[] preload, boolean preloadIgnoreError, ClassLoader cl) {
                if (preload != null) {
                    for (String preloadLibname : preload) {
                        this.loadLibrary(preloadLibname, preloadIgnoreError, cl);
                    }
                }
                this.loadLibrary(libname, false, cl);
            }

            public boolean loadLibrary(String libname, boolean ignoreError, ClassLoader cl) {
                boolean result;
                block4: {
                    result = true;
                    Util.getLogger().info("Requested library " + libname);
                    try {
                        String path = basePath + File.separator + System.mapLibraryName(libname);
                        System.load(path);
                        Util.getLogger().info("Loaded " + path);
                    }
                    catch (UnsatisfiedLinkError e) {
                        Util.getLogger().info("Library load failed, trying fallback to System.loadLibrary");
                        try {
                            System.loadLibrary(libname);
                            Util.getLogger().info("Loaded system library " + libname);
                        }
                        catch (UnsatisfiedLinkError e2) {
                            Util.getLogger().info("System library load failed");
                            result = false;
                            if (ignoreError) break block4;
                            throw e2;
                        }
                    }
                }
                return result;
            }
        });
    }

    public static void initLogger() {
        try {
            logger = Logger.getLogger("log");
            logger.info("Log started");
            String nl = System.getProperty("line.separator");
            logger.info("GlueGen version " + GlueGenVersion.getInstance().getImplementationVersion());
            logger.info("JOGL version " + JoglVersion.getInstance().getImplementationVersion());
            Properties p = System.getProperties();
            Object props = "";
            for (Object key : p.keySet()) {
                props = (String)props + key + ": ";
                props = (String)props + p.get(key);
                props = (String)props + nl;
            }
            logger.info("System properties:" + nl + (String)props);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public static Vector3D transformPoint(RealMatrix matrix, Vector3D point) {
        if (matrix.getColumnDimension() != 4 || matrix.getRowDimension() != 4) {
            throw new IllegalArgumentException("not a 4x4-matrix");
        }
        double[] tmp = matrix.operate(new double[]{point.getX(), point.getY(), point.getZ(), 1.0});
        return new Vector3D(tmp[0], tmp[1], tmp[2]);
    }

    public static Vector3D transformVector(RealMatrix matrix, Vector3D vector) {
        if (matrix.getColumnDimension() != 4 || matrix.getRowDimension() != 4) {
            throw new IllegalArgumentException("not a 4x4-matrix");
        }
        double[] tmp = matrix.operate(new double[]{vector.getX(), vector.getY(), vector.getZ(), 0.0});
        return new Vector3D(tmp[0], tmp[1], tmp[2]);
    }
}

