/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl;

import org.apache.commons.math.geometry.Vector3D;

public class Plane {
    private Vector3D normal;
    private double distance;

    public Plane(Vector3D normal, Vector3D position) {
        this.normal = normal.normalize();
        this.distance = -Vector3D.dotProduct((Vector3D)this.normal, (Vector3D)position);
    }

    public Plane(Vector3D normal, double distance) {
        this.normal = normal.normalize();
        this.distance = distance;
    }

    public double intersectRay(Vector3D rayOrigin, Vector3D rayDirection) {
        double denom = Vector3D.dotProduct((Vector3D)rayDirection, (Vector3D)this.normal);
        if (Math.abs(denom) < 1.0E-7) {
            return Double.MAX_VALUE;
        }
        double lambda = -(Vector3D.dotProduct((Vector3D)rayOrigin, (Vector3D)this.normal) + this.distance) / denom;
        return lambda;
    }

    public double intersectRayWithShift(Vector3D rayOrigin, Vector3D rayDirection, double shift) {
        double denom = Vector3D.dotProduct((Vector3D)rayDirection, (Vector3D)this.normal);
        if (Math.abs(denom) < 1.0E-7) {
            return Double.MAX_VALUE;
        }
        double lambda = -(Vector3D.dotProduct((Vector3D)rayOrigin, (Vector3D)this.normal) + this.distance - shift) / denom;
        return lambda;
    }

    public double distance(Vector3D point) {
        return Vector3D.dotProduct((Vector3D)this.normal, (Vector3D)point) + this.distance;
    }
}

