/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl;

import de.tum.in.cindy3dplugin.jogl.Plane;
import de.tum.in.cindy3dplugin.jogl.Util;
import org.apache.commons.math.geometry.Rotation;
import org.apache.commons.math.geometry.Vector3D;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;

public class ModelViewerCamera {
    private static final double ROTATE_SENSITIVITY = 0.01;
    private Rotation orientation;
    private Vector3D position;
    private Vector3D lookAt;
    private RealMatrix transform;
    private double zNear;
    private double zFar;
    private double fieldOfView;
    private double aspectRatio;
    private RealMatrix perspectiveTransform;
    private double lodFactor;
    private Plane[] clippingPlanes = new Plane[6];

    public ModelViewerCamera() {
        this.transform = MatrixUtils.createRealMatrix((int)4, (int)4);
        this.perspectiveTransform = MatrixUtils.createRealMatrix((int)4, (int)4);
        this.orientation = Rotation.IDENTITY;
        this.lookAt(Vector3D.PLUS_K, Vector3D.ZERO, Vector3D.PLUS_J);
        this.setPerspective(45.0, 640, 480, 0.1, 100.0);
    }

    private void updatePerspectiveTransform() {
        double f = 1.0 / Math.tan(Math.toRadians(this.fieldOfView) * 0.5);
        double nearMinusFar = this.zNear - this.zFar;
        this.perspectiveTransform.setEntry(0, 0, f / this.aspectRatio);
        this.perspectiveTransform.setEntry(1, 1, f);
        this.perspectiveTransform.setEntry(2, 2, (this.zFar + this.zNear) / nearMinusFar);
        this.perspectiveTransform.setEntry(2, 3, 2.0 * this.zFar * this.zNear / nearMinusFar);
        this.perspectiveTransform.setEntry(3, 2, -1.0);
        this.buildClippingPlanes();
    }

    private void updateTransform() {
        RealMatrix lookAtRotationMatrix = MatrixUtils.createRealIdentityMatrix((int)4);
        lookAtRotationMatrix.setSubMatrix(this.orientation.getMatrix(), 0, 0);
        RealMatrix lookAtTranslationMatrix = MatrixUtils.createRealIdentityMatrix((int)4);
        lookAtTranslationMatrix.setColumn(3, new double[]{-this.position.getX(), -this.position.getY(), -this.position.getZ(), 1.0});
        this.transform = lookAtRotationMatrix.multiply(lookAtTranslationMatrix);
    }

    private void buildClippingPlanes() {
        int i;
        RealMatrix invProjection = new LUDecompositionImpl(this.perspectiveTransform).getSolver().getInverse();
        RealVector[] f = new RealVector[]{MatrixUtils.createRealVector((double[])new double[]{-1.0, -1.0, 1.0, 1.0}), MatrixUtils.createRealVector((double[])new double[]{-1.0, -1.0, -1.0, 1.0}), MatrixUtils.createRealVector((double[])new double[]{-1.0, 1.0, -1.0, 1.0}), MatrixUtils.createRealVector((double[])new double[]{1.0, 1.0, -1.0, 1.0}), MatrixUtils.createRealVector((double[])new double[]{1.0, 1.0, 1.0, 1.0}), MatrixUtils.createRealVector((double[])new double[]{1.0, -1.0, 1.0, 1.0})};
        for (int i2 = 0; i2 < 6; ++i2) {
            f[i2] = invProjection.operate(f[i2]);
            f[i2].mapDivideToSelf(f[i2].getEntry(3));
        }
        Vector3D[] frustumVertices = new Vector3D[6];
        for (i = 0; i < 6; ++i) {
            frustumVertices[i] = new Vector3D(f[i].getEntry(0), f[i].getEntry(1), f[i].getEntry(2));
        }
        for (i = 0; i < 6; ++i) {
            Vector3D v1 = frustumVertices[(i + 1) % 6].subtract(frustumVertices[i]);
            Vector3D v2 = frustumVertices[(i + 2) % 6].subtract(frustumVertices[i]);
            Vector3D normal = Vector3D.crossProduct((Vector3D)v1, (Vector3D)v2);
            if (i % 2 == 1) {
                normal = normal.negate();
            }
            this.clippingPlanes[i] = new Plane(normal.normalize(), frustumVertices[i]);
        }
    }

    public void lookAt(Vector3D position, Vector3D lookAt, Vector3D up) {
        this.position = position;
        this.lookAt = lookAt;
        this.orientation = new Rotation(lookAt.subtract(position), up, Vector3D.MINUS_K, Vector3D.PLUS_J);
        this.updateTransform();
    }

    public RealMatrix getTransform() {
        return this.transform;
    }

    public Plane[] getClippingPlanes() {
        return this.clippingPlanes;
    }

    public void setPerspective(double fieldOfView, int width, int height, double zNear, double zFar) {
        if (height <= 0) {
            height = 1;
        }
        this.aspectRatio = (double)width / (double)height;
        this.fieldOfView = fieldOfView;
        this.zNear = zNear;
        this.zFar = zFar;
        this.updatePerspectiveTransform();
        this.lodFactor = 2.0 * Math.tan(0.5 * Math.toRadians(this.fieldOfView) / this.aspectRatio) / (double)height;
    }

    public RealMatrix getPerspectiveTransform() {
        return this.perspectiveTransform;
    }

    public Rotation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Rotation orientation) {
        this.orientation = orientation;
        this.updateTransform();
    }

    public Vector3D getPosition() {
        return this.position;
    }

    public Vector3D getLookAt() {
        return this.lookAt;
    }

    public Vector3D getUp() {
        return this.orientation.applyInverseTo(Vector3D.PLUS_J);
    }

    public Vector3D getForward() {
        return this.orientation.applyInverseTo(Vector3D.MINUS_K);
    }

    public Vector3D getRight() {
        return this.orientation.applyInverseTo(Vector3D.PLUS_I);
    }

    public double getFieldOfView() {
        return this.fieldOfView;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public double getZNear() {
        return this.zNear;
    }

    public double getZFar() {
        return this.zFar;
    }

    public void mouseRotate(double dx, double dy) {
        Rotation rotation = new Rotation(this.getUp(), -dx * 0.01).applyTo(new Rotation(this.getRight(), -dy * 0.01));
        this.position = rotation.applyTo(this.position.subtract(this.lookAt)).add(this.lookAt);
        this.orientation = this.orientation.applyTo(rotation.revert());
        this.updateTransform();
    }

    public void mousePan(double dx, double dy) {
        Vector3D movement = Vector3D.ZERO.add(dx, this.getRight()).add(-dy, this.getUp());
        double factor = this.getWorldSpaceError(1.0, -Util.transformPoint(this.transform, this.lookAt).getZ());
        this.position = this.position.add(factor * this.aspectRatio, movement);
        this.lookAt = this.lookAt.add(factor * this.aspectRatio, movement);
        this.updateTransform();
    }

    public void mouseWheel(int wheelRotation) {
        if (wheelRotation == 0) {
            return;
        }
        Vector3D lookAtToPosition = this.position.subtract(this.lookAt);
        Vector3D newPosition = wheelRotation > 0 ? this.lookAt.add(1.1, lookAtToPosition) : this.lookAt.add(0.9090909090909091, lookAtToPosition);
        this.position = newPosition;
        this.updateTransform();
    }

    public double getWorldSpaceError(double screenSpaceError, double cameraSpaceZ) {
        return this.lodFactor * screenSpaceError * -cameraSpaceZ;
    }
}

