/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin.jogl;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import de.tum.in.cindy3dplugin.AppearanceState;
import de.tum.in.cindy3dplugin.Cindy3DViewer;
import de.tum.in.cindy3dplugin.LightModificationInfo;
import de.tum.in.cindy3dplugin.jogl.Material;
import de.tum.in.cindy3dplugin.jogl.ModelViewerCamera;
import de.tum.in.cindy3dplugin.jogl.RenderHints;
import de.tum.in.cindy3dplugin.jogl.Util;
import de.tum.in.cindy3dplugin.jogl.lighting.LightManager;
import de.tum.in.cindy3dplugin.jogl.primitives.Circle;
import de.tum.in.cindy3dplugin.jogl.primitives.Line;
import de.tum.in.cindy3dplugin.jogl.primitives.Mesh;
import de.tum.in.cindy3dplugin.jogl.primitives.Polygon;
import de.tum.in.cindy3dplugin.jogl.primitives.Scene;
import de.tum.in.cindy3dplugin.jogl.primitives.Sphere;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.fixedfunc.FixedfuncPrimitiveRendererFactory;
import de.tum.in.cindy3dplugin.jogl.primitives.renderers.shader.ShaderPrimitiveRendererFactory;
import de.tum.in.cindy3dplugin.jogl.renderers.DefaultRenderer;
import de.tum.in.cindy3dplugin.jogl.renderers.JOGLRenderer;
import de.tum.in.cindy3dplugin.jogl.renderers.SupersampledRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.swing.JFrame;
import org.apache.commons.math.geometry.Vector3D;

public class JOGLViewer
extends MouseAdapter
implements Cindy3DViewer,
MouseMotionListener,
MouseWheelListener {
    private static final double POINT_SCALE = 0.05;
    private boolean standalone;
    private Container container;
    private GLCanvas canvas = null;
    private JOGLRenderer renderer = null;
    private Scene scene = new Scene();
    private ModelViewerCamera camera = new ModelViewerCamera();
    private LightManager lightManager = new LightManager();
    private double[] mousePosition = new double[2];
    private boolean drawPending = false;
    private final RenderHints[] qualityHints = new RenderHints[]{new RenderHints(RenderHints.RenderMode.FIXED_FUNCTION_PIPELINE, 1, 1.0), new RenderHints(RenderHints.RenderMode.FIXED_FUNCTION_PIPELINE, 2, 1.0), new RenderHints(RenderHints.RenderMode.FIXED_FUNCTION_PIPELINE, 4, 1.0), new RenderHints(RenderHints.RenderMode.FIXED_FUNCTION_PIPELINE, 8, 1.0), new RenderHints(RenderHints.RenderMode.PROGRAMMABLE_PIPELINE, 1, 1.0), new RenderHints(RenderHints.RenderMode.PROGRAMMABLE_PIPELINE, 2, 1.0), new RenderHints(RenderHints.RenderMode.PROGRAMMABLE_PIPELINE, 3, 1.0), new RenderHints(RenderHints.RenderMode.PROGRAMMABLE_PIPELINE, 4, 1.0), new RenderHints(RenderHints.RenderMode.PROGRAMMABLE_PIPELINE, 8, 1.0)};
    private RenderHints renderHints = null;
    private RenderHints requestedRenderHints = null;

    public JOGLViewer() {
        this(null);
    }

    public JOGLViewer(Container container) {
        Util.initLogger();
        Util.setupGluegenClassLoading();
        if (container == null) {
            this.standalone = true;
            Util.getLogger().info("Creating standalone frame");
            JFrame frame = new JFrame("Cindy3D (JOGL)");
            frame.setDefaultCloseOperation(1);
            frame.setLayout(new BorderLayout());
            frame.setSize(640, 480);
            this.container = frame;
        } else {
            this.standalone = false;
            this.container = container;
        }
        this.camera.lookAt(new Vector3D(0.0, 0.0, 5.0), Vector3D.ZERO, Vector3D.PLUS_J);
        try {
            Util.getLogger().info("Trying to call GLProfile.initSingleton");
            GLProfile.initSingleton();
        }
        catch (Exception e) {
            Util.getLogger().log(Level.SEVERE, e.toString(), e);
        }
        this.applyHints(this.qualityHints[0]);
    }

    private void applyHints(RenderHints hints) {
        Util.getLogger().info("Creating renderer");
        if (this.renderHints != null && this.renderHints.equals(hints)) {
            return;
        }
        this.renderHints = hints;
        try {
            GLProfile profile = GLProfile.getDefault();
            GLCapabilities caps = new GLCapabilities(profile);
            if (hints.getRenderMode() == RenderHints.RenderMode.FIXED_FUNCTION_PIPELINE) {
                if (hints.getSamplingRate() > 1) {
                    caps.setSampleBuffers(true);
                    caps.setNumSamples(hints.getSamplingRate());
                }
                this.renderer = new DefaultRenderer(hints, this.scene, this.camera, this.lightManager, new FixedfuncPrimitiveRendererFactory());
            } else {
                this.renderer = hints.getSamplingRate() == 1 ? new DefaultRenderer(hints, this.scene, this.camera, this.lightManager, new ShaderPrimitiveRendererFactory()) : new SupersampledRenderer(hints, this.scene, this.camera, this.lightManager, new ShaderPrimitiveRendererFactory());
            }
            Util.getLogger().info("GLProfile: " + profile);
            Util.getLogger().info("GLCapabilities: " + caps);
            if (this.canvas != null) {
                this.canvas.destroy();
                this.container.remove((Component)this.canvas);
            }
            Util.getLogger().info("Renderer: " + this.renderer);
            Util.getLogger().info("Creating canvas");
            this.canvas = new GLCanvas((GLCapabilitiesImmutable)caps);
            this.canvas.addGLEventListener((GLEventListener)this.renderer);
            this.canvas.addMouseListener((MouseListener)this);
            this.canvas.addMouseMotionListener((MouseMotionListener)this);
            this.canvas.addMouseWheelListener((MouseWheelListener)this);
            this.canvas.setSize(this.container.getSize());
            Util.getLogger().info("Canvas: " + this.canvas.getClass().getCanonicalName());
            this.container.add((Component)this.canvas, "Center");
        }
        catch (Exception e) {
            Util.getLogger().log(Level.SEVERE, e.toString(), e);
        }
    }

    @Override
    public void begin() {
        Util.getLogger().info("begin()");
        if (this.requestedRenderHints != null) {
            this.applyHints(this.requestedRenderHints);
        }
        this.scene.clear();
    }

    @Override
    public void end() {
        Util.getLogger().info("end()");
        try {
            Util.getLogger().info("Setting container visible");
            if (!this.container.isVisible()) {
                this.container.setVisible(true);
            }
            Util.getLogger().info("Calling canvas.display()");
            this.canvas.display();
        }
        catch (Exception e) {
            Util.getLogger().log(Level.SEVERE, e.toString(), e);
        }
    }

    @Override
    public void shutdown() {
        Util.getLogger().info("shutdown()");
        if (this.standalone && this.container instanceof JFrame) {
            ((JFrame)this.container).dispose();
        }
        this.container = null;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.scene.setBackgroundColor(color);
    }

    @Override
    public void addPoint(double x, double y, double z, AppearanceState appearance) {
        this.scene.addSphere(new Sphere(x, y, z, appearance.getSize() * 0.05, new Material(appearance.getColor(), appearance.getShininess(), 1.0)));
    }

    @Override
    public void addCircle(double cx, double cy, double cz, double nx, double ny, double nz, double radius, AppearanceState appearance) {
        this.scene.addCircle(new Circle(cx, cy, cz, nx, ny, nz, radius, new Material(appearance.getColor(), appearance.getShininess(), appearance.getAlpha())));
    }

    @Override
    public void addSegment(double x1, double y1, double z1, double x2, double y2, double z2, AppearanceState appearance) {
        this.addPoint(x1, y1, z1, appearance);
        this.addPoint(x2, y2, z2, appearance);
        this.scene.addLine(new Line(x1, y1, z1, x2, y2, z2, appearance.getSize() * 0.05, Line.LineType.SEGMENT, new Material(appearance.getColor(), appearance.getShininess(), 1.0)));
    }

    @Override
    public void addLine(double x1, double y1, double z1, double x2, double y2, double z2, AppearanceState appearance) {
        this.scene.addLine(new Line(x1, y1, z1, x2, y2, z2, appearance.getSize() * 0.05, Line.LineType.LINE, new Material(appearance.getColor(), appearance.getShininess(), 1.0)));
    }

    @Override
    public void addRay(double x1, double y1, double z1, double x2, double y2, double z2, AppearanceState appearance) {
        this.addPoint(x1, y1, z1, appearance);
        this.scene.addLine(new Line(x1, y1, z1, x2, y2, z2, appearance.getSize() * 0.05, Line.LineType.RAY, new Material(appearance.getColor(), appearance.getShininess(), 1.0)));
    }

    @Override
    public void addPolygon(double[][] vertices, double[][] normals, AppearanceState appearance) {
        this.scene.addPolygon(new Polygon(vertices, normals, new Material(appearance.getColor(), appearance.getShininess(), appearance.getAlpha())));
    }

    @Override
    public void addLineStrip(double[][] vertices, AppearanceState appearance, boolean closed) {
        for (int i = 1; i < vertices.length; ++i) {
            this.scene.addLine(new Line(vertices[i - 1][0], vertices[i - 1][1], vertices[i - 1][2], vertices[i][0], vertices[i][1], vertices[i][2], appearance.getSize() * 0.05, Line.LineType.SEGMENT, new Material(appearance.getColor(), appearance.getShininess(), 1.0)));
            this.scene.addSphere(new Sphere(vertices[i][0], vertices[i][1], vertices[i][2], appearance.getSize() * 0.05, new Material(appearance.getColor(), appearance.getShininess(), 1.0)));
        }
        this.scene.addSphere(new Sphere(vertices[0][0], vertices[0][1], vertices[0][2], appearance.getSize() * 0.05, new Material(appearance.getColor(), appearance.getShininess(), 1.0)));
        if (closed) {
            this.scene.addLine(new Line(vertices[vertices.length - 1][0], vertices[vertices.length - 1][1], vertices[vertices.length - 1][2], vertices[0][0], vertices[0][1], vertices[0][2], appearance.getSize() * 0.05, Line.LineType.SEGMENT, new Material(appearance.getColor(), appearance.getShininess(), 1.0)));
        }
    }

    @Override
    public void addMesh(int rows, int columns, double[][] vertices, double[][] normals, Cindy3DViewer.MeshTopology topology, AppearanceState appearance) {
        this.scene.addMesh(new Mesh(rows, columns, vertices, normals, topology, new Material(appearance.getColor(), appearance.getShininess(), appearance.getAlpha())));
    }

    @Override
    public void addMesh(int rows, int columns, double[][] vertices, Cindy3DViewer.NormalType normalType, Cindy3DViewer.MeshTopology topology, AppearanceState appearance) {
        this.scene.addMesh(new Mesh(rows, columns, vertices, normalType, topology, new Material(appearance.getColor(), appearance.getShininess(), appearance.getAlpha())));
    }

    @Override
    public void addSphere(double cx, double cy, double cz, double radius, AppearanceState appearance) {
        this.scene.addSphere(new Sphere(cx, cy, cz, radius, new Material(appearance.getColor(), appearance.getShininess(), appearance.getAlpha())));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePosition[0] = e.getX();
        this.mousePosition[1] = e.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0) {
            if (e.isControlDown() || e.isAltDown()) {
                this.camera.mousePan((double)e.getX() - this.mousePosition[0], (double)e.getY() - this.mousePosition[1]);
            } else {
                this.camera.mouseRotate((double)e.getX() - this.mousePosition[0], (double)e.getY() - this.mousePosition[1]);
            }
            this.drawLater();
        } else if ((e.getModifiers() & 4) != 0) {
            this.drawLater();
        }
        this.mousePosition[0] = e.getX();
        this.mousePosition[1] = e.getY();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.camera.mouseWheel(e.getWheelRotation());
        this.drawLater();
    }

    private void drawLater() {
        if (!this.drawPending) {
            this.drawPending = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOGLViewer.this.canvas.display();
                    JOGLViewer.this.drawPending = false;
                }
            });
        }
    }

    @Override
    public void setDepthRange(double near, double far) {
        this.camera.setPerspective(this.camera.getFieldOfView(), this.canvas.getWidth(), this.canvas.getHeight(), near, far);
    }

    @Override
    public void setLight(int light, LightModificationInfo info) {
        this.lightManager.setLight(light, info);
    }

    @Override
    public void disableLight(int light) {
        this.lightManager.disableLight(light);
    }

    @Override
    public void setRenderHints(Hashtable<String, Object> hints) {
        this.requestedRenderHints = this.renderHints.clone();
        Object value = hints.get("quality");
        if (value instanceof Double) {
            int quality = ((Double)value).intValue();
            quality = Math.max(0, Math.min(quality, this.qualityHints.length - 1));
            this.requestedRenderHints = this.qualityHints[quality];
        }
        if ((value = hints.get("screenError")) instanceof Double) {
            this.requestedRenderHints.setAllowedScreenSpaceError((Double)value);
        }
        if ((value = hints.get("renderMode")) instanceof String) {
            String renderMode = (String)value;
            if (renderMode.equalsIgnoreCase("simple")) {
                this.requestedRenderHints.setSamplingRate(1);
                this.requestedRenderHints.setRenderMode(RenderHints.RenderMode.FIXED_FUNCTION_PIPELINE);
            } else if (renderMode.equalsIgnoreCase("raycasted")) {
                this.requestedRenderHints.setSamplingRate(1);
                this.requestedRenderHints.setRenderMode(RenderHints.RenderMode.PROGRAMMABLE_PIPELINE);
            }
        }
        if ((value = hints.get("samplingRate")) instanceof Double) {
            this.requestedRenderHints.setSamplingRate(((Double)value).intValue());
        }
    }

    @Override
    public void setCamera(double eyeX, double eyeY, double eyeZ, double lookAtX, double lookAtY, double lookAtZ, double upX, double upY, double upZ) {
        this.camera.lookAt(new Vector3D(eyeX, eyeY, eyeZ), new Vector3D(lookAtX, lookAtY, lookAtZ), new Vector3D(upX, upY, upZ));
    }

    @Override
    public void setFieldOfView(double fieldOfView) {
        this.camera.setPerspective(fieldOfView, this.canvas.getWidth(), this.canvas.getHeight(), this.camera.getZNear(), this.camera.getZFar());
    }
}

