/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.cindy3dplugin;

import de.cinderella.api.cs.CindyScript;
import de.cinderella.api.cs.CindyScriptPlugin;
import de.cinderella.math.Vec;
import de.tum.in.cindy3dplugin.AppearanceState;
import de.tum.in.cindy3dplugin.Cindy3DViewer;
import de.tum.in.cindy3dplugin.LightModificationInfo;
import de.tum.in.cindy3dplugin.jogl.JOGLViewer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;

public class Cindy3DPlugin
extends CindyScriptPlugin {
    private Cindy3DViewer cindy3d = null;
    private Stack<AppearanceState> pointAppearanceStack;
    private AppearanceState pointAppearance;
    private Stack<AppearanceState> lineAppearanceStack;
    private AppearanceState lineAppearance;
    private Stack<AppearanceState> surfaceAppearanceStack;
    private AppearanceState surfaceAppearance;
    private Hashtable modifiers;

    public Cindy3DPlugin() {
        System.setProperty("jogamp.gluegen.UseTempJarCache", "false");
        this.pointAppearanceStack = new Stack();
        this.pointAppearance = new AppearanceState(Color.RED, 60.0, 1.0, 1.0);
        this.lineAppearanceStack = new Stack();
        this.lineAppearance = new AppearanceState(Color.BLUE, 60.0, 1.0, 1.0);
        this.surfaceAppearanceStack = new Stack();
        this.surfaceAppearance = new AppearanceState(Color.GREEN, 60.0, 1.0, 1.0);
    }

    public void register() {
        if (this.cindy3d == null) {
            this.cindy3d = new JOGLViewer(null);
        }
    }

    public void unregister() {
        if (this.cindy3d != null) {
            this.cindy3d.shutdown();
        }
        this.cindy3d = null;
    }

    public void setModifiers(Hashtable m) {
        this.modifiers = m;
    }

    public Hashtable getModifiers() {
        return this.modifiers;
    }

    public String getAuthor() {
        return "Jan Sommer and Matthias Reitinger";
    }

    public String getName() {
        return "Cindy3D";
    }

    @CindyScript(value="begin3d")
    public void begin3d() {
        this.cindy3d.begin();
    }

    @CindyScript(value="end3d")
    public void end3d() {
        this.cindy3d.end();
    }

    @CindyScript(value="draw3d")
    public void draw3d(ArrayList<Double> point) {
        if (point.size() != 3) {
            throw new IllegalArgumentException("point size not 3");
        }
        this.cindy3d.addPoint(point.get(0), point.get(1), point.get(2), Cindy3DPlugin.applyAppearanceModifiers(this.pointAppearance, this.getModifiers()));
    }

    @CindyScript(value="draw3d")
    public void draw3d(ArrayList<Double> firstPoint, ArrayList<Double> secondPoint) {
        if (firstPoint.size() != 3) {
            throw new IllegalArgumentException("first point size not 3");
        }
        if (secondPoint.size() != 3) {
            throw new IllegalArgumentException("second point size not 3");
        }
        Hashtable<String, String> modifiers = new Hashtable<String, String>();
        modifiers.put("type", "Segment");
        modifiers.putAll(this.modifiers);
        String type = modifiers.get("type").toString();
        AppearanceState appearance = Cindy3DPlugin.applyAppearanceModifiers(this.lineAppearance, this.getModifiers());
        if (type.equalsIgnoreCase("segment")) {
            this.cindy3d.addSegment(firstPoint.get(0), firstPoint.get(1), firstPoint.get(2), secondPoint.get(0), secondPoint.get(1), secondPoint.get(2), appearance);
        } else if (type.equalsIgnoreCase("line")) {
            this.cindy3d.addLine(firstPoint.get(0), firstPoint.get(1), firstPoint.get(2), secondPoint.get(0), secondPoint.get(1), secondPoint.get(2), appearance);
        } else if (type.equalsIgnoreCase("ray")) {
            this.cindy3d.addRay(firstPoint.get(0), firstPoint.get(1), firstPoint.get(2), secondPoint.get(0), secondPoint.get(1), secondPoint.get(2), appearance);
        }
    }

    @CindyScript(value="connect3d")
    public void connect3d(ArrayList<Vec> points) {
        if (points.isEmpty()) {
            throw new IllegalArgumentException("no points");
        }
        double[][] vertices = new double[points.size()][3];
        for (int i = 0; i < points.size(); ++i) {
            vertices[i][0] = points.get(i).getXR();
            vertices[i][1] = points.get(i).getYR();
            vertices[i][2] = points.get(i).getZR();
        }
        this.cindy3d.addLineStrip(vertices, Cindy3DPlugin.applyAppearanceModifiers(this.lineAppearance, this.getModifiers()), false);
    }

    @CindyScript(value="drawpoly3d")
    public void drawpoly3d(ArrayList<Vec> points) {
        if (points.isEmpty()) {
            throw new IllegalArgumentException("no vertices");
        }
        double[][] vertices = new double[points.size()][3];
        for (int i = 0; i < points.size(); ++i) {
            vertices[i][0] = points.get(i).getXR();
            vertices[i][1] = points.get(i).getYR();
            vertices[i][2] = points.get(i).getZR();
        }
        this.cindy3d.addLineStrip(vertices, Cindy3DPlugin.applyAppearanceModifiers(this.lineAppearance, this.getModifiers()), true);
    }

    @CindyScript(value="fillpoly3d")
    public void fillpoly3d(ArrayList<Vec> points) {
        if (points.size() == 0) {
            throw new IllegalArgumentException("no points");
        }
        double[][] pointsArray = new double[points.size()][3];
        for (int i = 0; i < points.size(); ++i) {
            pointsArray[i][0] = points.get(i).getXR();
            pointsArray[i][1] = points.get(i).getYR();
            pointsArray[i][2] = points.get(i).getZR();
        }
        this.cindy3d.addPolygon(pointsArray, null, Cindy3DPlugin.applyAppearanceModifiers(this.surfaceAppearance, this.getModifiers()));
    }

    @CindyScript(value="fillpoly3d")
    public void fillpoly3d(ArrayList<Vec> points, ArrayList<Vec> normals) {
        if (points.size() == 0) {
            throw new IllegalArgumentException("no points");
        }
        if (normals.size() == 0) {
            throw new IllegalArgumentException("no normals");
        }
        if (points.size() != normals.size()) {
            throw new IllegalArgumentException("points and normals have different sizes");
        }
        double[][] pointsArray = new double[points.size()][3];
        double[][] normalsArray = new double[normals.size()][3];
        for (int i = 0; i < points.size(); ++i) {
            pointsArray[i][0] = points.get(i).getXR();
            pointsArray[i][1] = points.get(i).getYR();
            pointsArray[i][2] = points.get(i).getZR();
            if (normals == null) continue;
            normalsArray[i][0] = normals.get(i).getXR();
            normalsArray[i][1] = normals.get(i).getYR();
            normalsArray[i][2] = normals.get(i).getZR();
        }
        this.cindy3d.addPolygon(pointsArray, normalsArray, Cindy3DPlugin.applyAppearanceModifiers(this.surfaceAppearance, this.getModifiers()));
    }

    @CindyScript(value="fillcircle3d")
    public void fillcircle3d(ArrayList<Double> center, ArrayList<Double> normal, double radius) {
        if (center.size() != 3) {
            throw new IllegalArgumentException("center size not 3");
        }
        if (normal.size() != 3) {
            throw new IllegalArgumentException("normal size not 3");
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException("radius not positive");
        }
        this.cindy3d.addCircle(center.get(0), center.get(1), center.get(2), normal.get(0), normal.get(1), normal.get(2), radius, Cindy3DPlugin.applyAppearanceModifiers(this.surfaceAppearance, this.getModifiers()));
    }

    @CindyScript(value="mesh3d")
    public void mesh3d(int rows, int columns, ArrayList<Vec> points) {
        if (rows <= 0) {
            throw new IllegalArgumentException("row count not positive");
        }
        if (columns <= 0) {
            throw new IllegalArgumentException("row count not positive");
        }
        if (rows * columns != points.size()) {
            throw new IllegalArgumentException("wrong point count");
        }
        Hashtable<String, String> modifiers = new Hashtable<String, String>();
        modifiers.put("normaltype", "perface");
        modifiers.put("topology", "open");
        modifiers.putAll(this.modifiers);
        String type = modifiers.get("normaltype").toString();
        Cindy3DViewer.NormalType normalType = Cindy3DViewer.NormalType.PER_FACE;
        if (type.equalsIgnoreCase("pervertex")) {
            normalType = Cindy3DViewer.NormalType.PER_VERTEX;
        }
        double[][] vertices = new double[points.size()][3];
        for (int i = 0; i < points.size(); ++i) {
            Vec v = points.get(i);
            vertices[i][0] = v.getXR();
            vertices[i][1] = v.getYR();
            vertices[i][2] = v.getZR();
        }
        String topologyStr = modifiers.get("topology").toString();
        Cindy3DViewer.MeshTopology topology = Cindy3DViewer.MeshTopology.OPEN;
        if (topologyStr.equalsIgnoreCase("open")) {
            topology = Cindy3DViewer.MeshTopology.OPEN;
        } else if (topologyStr.equalsIgnoreCase("closerows")) {
            topology = Cindy3DViewer.MeshTopology.CLOSE_ROWS;
        } else if (topologyStr.equalsIgnoreCase("closecolumns")) {
            topology = Cindy3DViewer.MeshTopology.CLOSE_COLUMNS;
        } else if (topologyStr.equalsIgnoreCase("closeboth")) {
            topology = Cindy3DViewer.MeshTopology.CLOSE_BOTH;
        }
        this.cindy3d.addMesh(rows, columns, vertices, normalType, topology, Cindy3DPlugin.applyAppearanceModifiers(this.surfaceAppearance, this.getModifiers()));
    }

    @CindyScript(value="mesh3d")
    public void mesh3d(int rows, int columns, ArrayList<Vec> points, ArrayList<Vec> normals) {
        if (rows <= 0) {
            throw new IllegalArgumentException("row count not positive");
        }
        if (columns <= 0) {
            throw new IllegalArgumentException("row count not positive");
        }
        if (rows * columns != points.size()) {
            throw new IllegalArgumentException("wrong point count");
        }
        if (rows * columns != normals.size()) {
            throw new IllegalArgumentException("wrong normal count");
        }
        double[][] pointsArray = new double[points.size()][3];
        double[][] normalsArray = new double[normals.size()][3];
        for (int i = 0; i < points.size(); ++i) {
            Vec v = points.get(i);
            pointsArray[i][0] = v.getXR();
            pointsArray[i][1] = v.getYR();
            pointsArray[i][2] = v.getZR();
            v = normals.get(i);
            normalsArray[i][0] = v.getXR();
            normalsArray[i][1] = v.getYR();
            normalsArray[i][2] = v.getZR();
        }
        Hashtable<String, String> modifiers = new Hashtable<String, String>();
        modifiers.put("topology", "open");
        modifiers.putAll(this.modifiers);
        String topologyStr = modifiers.get("topology").toString();
        Cindy3DViewer.MeshTopology topology = Cindy3DViewer.MeshTopology.OPEN;
        if (topologyStr.equalsIgnoreCase("open")) {
            topology = Cindy3DViewer.MeshTopology.OPEN;
        } else if (topologyStr.equalsIgnoreCase("closerows")) {
            topology = Cindy3DViewer.MeshTopology.CLOSE_ROWS;
        } else if (topologyStr.equalsIgnoreCase("closecolumns")) {
            topology = Cindy3DViewer.MeshTopology.CLOSE_COLUMNS;
        } else if (topologyStr.equalsIgnoreCase("closeboth")) {
            topology = Cindy3DViewer.MeshTopology.CLOSE_BOTH;
        }
        this.cindy3d.addMesh(rows, columns, pointsArray, normalsArray, topology, Cindy3DPlugin.applyAppearanceModifiers(this.surfaceAppearance, this.getModifiers()));
    }

    @CindyScript(value="drawsphere3d")
    public void sphere3d(ArrayList<Double> center, double radius) {
        if (center.size() != 3) {
            throw new IllegalArgumentException("center size not 3");
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException("radius not positive");
        }
        this.cindy3d.addSphere(center.get(0), center.get(1), center.get(2), radius, Cindy3DPlugin.applyAppearanceModifiers(this.surfaceAppearance, this.getModifiers()));
    }

    @CindyScript(value="gsave3d")
    public void gsave3d() {
        this.pointAppearanceStack.push(this.pointAppearance.clone());
        this.lineAppearanceStack.push(this.lineAppearance.clone());
        this.surfaceAppearanceStack.push(this.surfaceAppearance.clone());
    }

    @CindyScript(value="grestore3d")
    public void grestore3d() {
        if (this.pointAppearanceStack.isEmpty() || this.lineAppearanceStack.isEmpty() || this.surfaceAppearanceStack.isEmpty()) {
            throw new IllegalStateException("appearance stack empty");
        }
        if (!this.pointAppearanceStack.isEmpty()) {
            this.pointAppearance = this.pointAppearanceStack.pop();
        }
        if (!this.lineAppearanceStack.isEmpty()) {
            this.lineAppearance = this.lineAppearanceStack.pop();
        }
        if (!this.surfaceAppearanceStack.isEmpty()) {
            this.surfaceAppearance = this.surfaceAppearanceStack.pop();
        }
    }

    @CindyScript(value="color3d")
    public void color3d(ArrayList<Double> color) {
        if (color.size() != 3) {
            throw new IllegalArgumentException("color size not 3");
        }
        this.pointAppearance.setColor(Cindy3DPlugin.convertToColor(color));
        this.lineAppearance.setColor(Cindy3DPlugin.convertToColor(color));
        this.surfaceAppearance.setColor(Cindy3DPlugin.convertToColor(color));
    }

    @CindyScript(value="pointcolor3d")
    public void pointcolor3d(ArrayList<Double> color) {
        if (color.size() != 3) {
            throw new IllegalArgumentException("color size not 3");
        }
        this.pointAppearance.setColor(Cindy3DPlugin.convertToColor(color));
    }

    @CindyScript(value="linecolor3d")
    public void linecolor3d(ArrayList<Double> color) {
        if (color.size() != 3) {
            throw new IllegalArgumentException("color size not 3");
        }
        this.lineAppearance.setColor(Cindy3DPlugin.convertToColor(color));
    }

    @CindyScript(value="surfacecolor3d")
    public void surfacecolor3d(ArrayList<Double> color) {
        if (color.size() != 3) {
            throw new IllegalArgumentException("color size not 3");
        }
        this.surfaceAppearance.setColor(Cindy3DPlugin.convertToColor(color));
    }

    @CindyScript(value="alpha3d")
    public void alpha3d(double alpha) {
        alpha = Math.max(0.0, Math.min(1.0, alpha));
        this.surfaceAppearance.setAlpha(alpha);
    }

    @CindyScript(value="surfacealpha3d")
    public void surfacealpha3d(double alpha) {
        this.surfaceAppearance.setAlpha(Math.max(0.0, Math.min(1.0, alpha)));
    }

    @CindyScript(value="shininess3d")
    public void shininess3d(double shininess) {
        shininess = Math.max(0.0, Math.min(128.0, shininess));
        this.pointAppearance.setShininess(shininess);
        this.lineAppearance.setShininess(shininess);
        this.surfaceAppearance.setShininess(shininess);
    }

    @CindyScript(value="pointshininess3d")
    public void pointshininess3d(double shininess) {
        this.pointAppearance.setShininess(Math.max(0.0, Math.min(128.0, shininess)));
    }

    @CindyScript(value="lineshininess3d")
    public void lineshininess3d(double shininess) {
        this.lineAppearance.setShininess(Math.max(0.0, Math.min(128.0, shininess)));
    }

    @CindyScript(value="surfaceshininess3d")
    public void surfaceshininess3d(double shininess) {
        this.surfaceAppearance.setShininess(Math.max(0.0, Math.min(128.0, shininess)));
    }

    @CindyScript(value="size3d")
    public void size3d(double size) {
        if (size <= 0.0) {
            throw new IllegalArgumentException("size not positive");
        }
        this.pointAppearance.setSize(size);
        this.lineAppearance.setSize(size);
        this.surfaceAppearance.setSize(size);
    }

    @CindyScript(value="pointsize3d")
    public void pointsize3d(double size) {
        if (size <= 0.0) {
            throw new IllegalArgumentException("size not positive");
        }
        this.pointAppearance.setSize(size);
    }

    @CindyScript(value="linesize3d")
    public void linesize3d(double size) {
        if (size <= 0.0) {
            throw new IllegalArgumentException("size not positive");
        }
        this.lineAppearance.setSize(size);
    }

    @CindyScript(value="background3d")
    public void background3d(ArrayList<Double> color) {
        if (color.size() != 3) {
            throw new IllegalArgumentException("color size not 3");
        }
        this.cindy3d.setBackgroundColor(Cindy3DPlugin.convertToColor(color));
    }

    @CindyScript(value="depthrange3d")
    public void depthrange3d(double near, double far) {
        if (near <= 0.0) {
            throw new IllegalArgumentException("near distance not positive");
        }
        if (far <= 0.0) {
            throw new IllegalArgumentException("far distance not positive");
        }
        if (near >= far) {
            throw new IllegalArgumentException("near distance not smaller than far distance");
        }
        this.cindy3d.setDepthRange(near, far);
    }

    @CindyScript(value="renderhints3d")
    public void renderhints3d() {
        this.cindy3d.setRenderHints(this.modifiers);
    }

    @CindyScript(value="disablelight3d")
    public void disablelight3d(int light) {
        if (light < 0 || light >= 8) {
            throw new IndexOutOfBoundsException("light index out of bounds");
        }
        this.cindy3d.disableLight(light);
    }

    @CindyScript(value="pointlight3d")
    public void pointlight3d(int light) {
        if (light < 0 || light >= 8) {
            throw new IndexOutOfBoundsException("light index out of bounds");
        }
        this.cindy3d.setLight(light, Cindy3DPlugin.getLightModificationInfoFromModifiers(LightModificationInfo.LightType.POINT_LIGHT, this.modifiers));
    }

    @CindyScript(value="directionallight3d")
    public void directionallight3d(int light) {
        if (light < 0 || light >= 8) {
            throw new IndexOutOfBoundsException("light index out of bounds");
        }
        this.cindy3d.setLight(light, Cindy3DPlugin.getLightModificationInfoFromModifiers(LightModificationInfo.LightType.DIRECTIONAL_LIGHT, this.modifiers));
    }

    @CindyScript(value="spotlight3d")
    public void spotlight3d(int light) {
        if (light < 0 || light >= 8) {
            throw new IndexOutOfBoundsException("light index out of bounds");
        }
        this.cindy3d.setLight(light, Cindy3DPlugin.getLightModificationInfoFromModifiers(LightModificationInfo.LightType.SPOT_LIGHT, this.modifiers));
    }

    @CindyScript(value="lookat3d")
    public void lookat3d(ArrayList<Double> eye, ArrayList<Double> lookat, ArrayList<Double> up) {
        if (eye.size() != 3) {
            throw new IllegalArgumentException("eye vector size not 3");
        }
        if (lookat.size() != 3) {
            throw new IllegalArgumentException("lookat vector size not 3");
        }
        if (up.size() != 3) {
            throw new IllegalArgumentException("up vector size not 3");
        }
        this.cindy3d.setCamera(eye.get(0), eye.get(1), eye.get(2), lookat.get(0), lookat.get(1), lookat.get(2), up.get(0), up.get(1), up.get(2));
    }

    @CindyScript(value="fieldofview3d")
    public void fieldofview3d(double fieldOfView) {
        if (fieldOfView <= 0.0 || fieldOfView >= Math.PI) {
            throw new IllegalArgumentException("field of view out of range");
        }
        this.cindy3d.setFieldOfView(Math.toDegrees(fieldOfView));
    }

    private static Color convertToColor(double[] color) {
        if (color.length != 3) {
            throw new IllegalArgumentException("color size not 3");
        }
        return new Color((float)Math.max(0.0, Math.min(1.0, color[0])), (float)Math.max(0.0, Math.min(1.0, color[1])), (float)Math.max(0.0, Math.min(1.0, color[2])));
    }

    private static Color convertToColor(ArrayList<Double> color) {
        if (color.size() != 3) {
            throw new IllegalArgumentException("color size not 3");
        }
        return new Color((float)Math.max(0.0, Math.min(1.0, color.get(0))), (float)Math.max(0.0, Math.min(1.0, color.get(1))), (float)Math.max(0.0, Math.min(1.0, color.get(2))));
    }

    private static AppearanceState applyAppearanceModifiers(AppearanceState initialState, Hashtable modifiers) {
        AppearanceState result = initialState.clone();
        Object value = null;
        value = modifiers.get("color");
        if (value instanceof double[]) {
            result.setColor(Cindy3DPlugin.convertToColor(value));
        }
        if ((value = modifiers.get("size")) instanceof Double) {
            result.setSize((Double)value);
        }
        if ((value = modifiers.get("alpha")) instanceof Double) {
            double alpha = Math.max(0.0, Math.min(1.0, (Double)value));
            result.setAlpha(alpha);
        }
        if ((value = modifiers.get("shininess")) instanceof Double) {
            double shininess = Math.max(0.0, Math.min(128.0, (Double)value));
            result.setShininess((int)shininess);
        }
        return result;
    }

    private static LightModificationInfo getLightModificationInfoFromModifiers(LightModificationInfo.LightType type, Hashtable modifiers) {
        double[] direction;
        double[] position;
        LightModificationInfo info = new LightModificationInfo(type);
        Object value = modifiers.get("ambient");
        if (value instanceof double[]) {
            info.setAmbient(Cindy3DPlugin.convertToColor((double[])value));
        }
        if ((value = modifiers.get("diffuse")) instanceof double[]) {
            info.setDiffuse(Cindy3DPlugin.convertToColor((double[])value));
        }
        if ((value = modifiers.get("specular")) instanceof double[]) {
            info.setSpecular(Cindy3DPlugin.convertToColor((double[])value));
        }
        if ((value = modifiers.get("position")) instanceof double[] && (position = (double[])value).length == 3) {
            info.setPosition(position);
        }
        if ((value = modifiers.get("direction")) instanceof double[] && (direction = (double[])value).length == 3) {
            info.setDirection(direction);
        }
        if ((value = modifiers.get("cutoffangle")) instanceof Double) {
            Double cutoffangle = (Double)value;
            info.setCutoffAngle(Math.toDegrees(cutoffangle));
        }
        if ((value = modifiers.get("exponent")) instanceof Double) {
            Double exponent = (Double)value;
            info.setSpotExponent(exponent);
        }
        if ((value = modifiers.get("frame")) instanceof String) {
            String frame = (String)value;
            if (frame.equalsIgnoreCase("world")) {
                info.setFrame(LightModificationInfo.LightFrame.WORLD);
            } else if (frame.equalsIgnoreCase("camera")) {
                info.setFrame(LightModificationInfo.LightFrame.CAMERA);
            }
        }
        return info;
    }
}

