/*
 * Decompiled with CFR 0.152.
 */
package redstone.xmlrpc;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import redstone.xmlrpc.XmlRpcCustomSerializer;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcMessages;
import redstone.xmlrpc.serializers.BooleanArraySerializer;
import redstone.xmlrpc.serializers.CollectionSerializer;
import redstone.xmlrpc.serializers.DoubleArraySerializer;
import redstone.xmlrpc.serializers.FloatArraySerializer;
import redstone.xmlrpc.serializers.IntArraySerializer;
import redstone.xmlrpc.serializers.IntrospectingSerializer;
import redstone.xmlrpc.serializers.ListSerializer;
import redstone.xmlrpc.serializers.LongArraySerializer;
import redstone.xmlrpc.serializers.LongPrimitiveSerializer;
import redstone.xmlrpc.serializers.LongWrapperSerializer;
import redstone.xmlrpc.serializers.MapSerializer;
import redstone.xmlrpc.serializers.ObjectArraySerializer;
import redstone.xmlrpc.util.Base64;

public class XmlRpcSerializer {
    protected List customSerializers = new ArrayList();
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

    public XmlRpcSerializer() {
        this(true);
    }

    public XmlRpcSerializer(boolean bl) {
        if (bl) {
            this.customSerializers.add(new LongPrimitiveSerializer());
            this.customSerializers.add(new LongWrapperSerializer());
            this.customSerializers.add(new MapSerializer());
            this.customSerializers.add(new ListSerializer());
            this.customSerializers.add(new CollectionSerializer());
            this.customSerializers.add(new ObjectArraySerializer());
            this.customSerializers.add(new IntArraySerializer());
            this.customSerializers.add(new FloatArraySerializer());
            this.customSerializers.add(new LongArraySerializer());
            this.customSerializers.add(new DoubleArraySerializer());
            this.customSerializers.add(new BooleanArraySerializer());
            this.customSerializers.add(new IntrospectingSerializer());
        }
    }

    public void writeEnvelopeHeader(Object object, Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"");
        writer.write(XmlRpcMessages.getString("XmlRpcServlet.Encoding"));
        writer.write("\"?><methodResponse><params><param>");
    }

    public void writeEnvelopeFooter(Object object, Writer writer) throws IOException {
        if (object != null) {
            writer.write("</param></params></methodResponse>");
        } else {
            writer.write("<value><string>void</string></value></param></params></methodResponse>");
        }
    }

    public void writeError(String string, Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"");
        writer.write(XmlRpcMessages.getString("XmlRpcServlet.Encoding"));
        writer.write("\"?>");
        writer.write("<methodResponse><fault><value><struct>");
        writer.write("<member><name>faultCode</name><value><int>-1</int></value>");
        writer.write("</member><member><name>faultString</name><value><string>");
        writer.write(string);
        writer.write("</string></value></member></struct></value></fault></methodResponse>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Object object, Writer writer) throws XmlRpcException, IOException {
        writer.write("<value>");
        if (object instanceof String || object instanceof Character) {
            writer.write("<string>");
            String string = object.toString();
            int n = string.length();
            block10: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '<': {
                        writer.write("&lt;");
                        continue block10;
                    }
                    case '&': {
                        writer.write("&amp;");
                        continue block10;
                    }
                    default: {
                        writer.write(c);
                    }
                }
            }
            writer.write("</string>");
        } else if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
            writer.write("<i4>");
            writer.write(object.toString());
            writer.write("</i4>");
        } else if (object instanceof Double || object instanceof Float) {
            writer.write("<double>");
            writer.write(object.toString());
            writer.write("</double>");
        } else if (object instanceof Boolean) {
            writer.write("<boolean>");
            writer.write((Boolean)object == true ? "1" : "0");
            writer.write("</boolean>");
        } else if (object instanceof Calendar) {
            writer.write("<dateTime.iso8601>");
            SimpleDateFormat simpleDateFormat = dateFormatter;
            synchronized (simpleDateFormat) {
                writer.write(dateFormatter.format(((Calendar)object).getTime()));
            }
            writer.write("</dateTime.iso8601>");
        } else if (object instanceof Date) {
            writer.write("<dateTime.iso8601>");
            SimpleDateFormat simpleDateFormat = dateFormatter;
            synchronized (simpleDateFormat) {
                writer.write(dateFormatter.format((Date)object));
            }
            writer.write("</dateTime.iso8601>");
        } else if (object instanceof byte[]) {
            writer.write("<base64>");
            writer.write(Base64.encode((byte[])object));
            writer.write("</base64>");
        } else {
            for (int i = 0; i < this.customSerializers.size(); ++i) {
                XmlRpcCustomSerializer xmlRpcCustomSerializer = (XmlRpcCustomSerializer)this.customSerializers.get(i);
                if (!xmlRpcCustomSerializer.getSupportedClass().isInstance(object)) continue;
                xmlRpcCustomSerializer.serialize(object, writer, this);
                writer.write("</value>");
                return;
            }
            throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcSerializer.UnsupportedType") + object.getClass());
        }
        writer.write("</value>");
    }

    public void addCustomSerializer(XmlRpcCustomSerializer xmlRpcCustomSerializer) {
        Class clazz = xmlRpcCustomSerializer.getSupportedClass();
        for (int i = 0; i < this.customSerializers.size(); ++i) {
            XmlRpcCustomSerializer xmlRpcCustomSerializer2 = (XmlRpcCustomSerializer)this.customSerializers.get(i);
            if (!xmlRpcCustomSerializer2.getSupportedClass().isAssignableFrom(clazz)) continue;
            this.customSerializers.add(i, xmlRpcCustomSerializer);
            return;
        }
        this.customSerializers.add(xmlRpcCustomSerializer);
    }

    public void removeCustomSerializer(XmlRpcCustomSerializer xmlRpcCustomSerializer) {
        this.customSerializers.remove(xmlRpcCustomSerializer);
    }
}

