/*
 * Decompiled with CFR 0.152.
 */
package redstone.xmlrpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import redstone.xmlrpc.XmlRpcCallback;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcFault;
import redstone.xmlrpc.XmlRpcInvocationHandler;
import redstone.xmlrpc.XmlRpcMessages;
import redstone.xmlrpc.XmlRpcParser;
import redstone.xmlrpc.XmlRpcSerializer;
import redstone.xmlrpc.XmlRpcStruct;

public class XmlRpcClient
extends XmlRpcParser
implements XmlRpcInvocationHandler {
    private URL url;
    private HttpURLConnection connection;
    private Map requestProperties;
    private Object returnValue;
    private Writer writer;
    private boolean streamMessages;
    private boolean isFaultResponse;
    private XmlRpcSerializer serializer = new XmlRpcSerializer();

    public XmlRpcClient(String string, boolean bl) throws MalformedURLException {
        this(new URL(string), bl);
    }

    public XmlRpcClient(URL uRL, boolean bl) {
        this.url = uRL;
        this.streamMessages = bl;
        if (!bl) {
            this.writer = new StringWriter(2048);
        }
    }

    public void setRequestProperties(Map map) {
        this.requestProperties = map;
    }

    public void setRequestProperty(String string, String string2) {
        if (this.requestProperties == null) {
            this.requestProperties = new HashMap();
        }
        this.requestProperties.put(string, string2);
    }

    public synchronized Object invoke(String string, List list) throws XmlRpcException, XmlRpcFault {
        this.beginCall(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    this.writer.write("<param>");
                    this.serializer.serialize(iterator.next(), this.writer);
                    this.writer.write("</param>");
                }
                catch (IOException iOException) {
                    throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcClient.NetworkError"), iOException);
                }
            }
        }
        return this.endCall();
    }

    public synchronized Object invoke(String string, Object[] objectArray) throws XmlRpcException, XmlRpcFault {
        this.beginCall(string);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    this.writer.write("<param>");
                    this.serializer.serialize(objectArray[i], this.writer);
                    this.writer.write("</param>");
                    continue;
                }
                catch (IOException iOException) {
                    throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcClient.NetworkError"), iOException);
                }
            }
        }
        return this.endCall();
    }

    public void invokeAsynchronously(final String string, final Object object, final XmlRpcCallback xmlRpcCallback) {
        if (xmlRpcCallback == null) {
            new Thread(){

                public void run() {
                    try {
                        if (object instanceof Object[]) {
                            XmlRpcClient.this.invoke(string, (Object[])object);
                        } else {
                            XmlRpcClient.this.invoke(string, (List)object);
                        }
                    }
                    catch (XmlRpcFault xmlRpcFault) {
                    }
                    catch (XmlRpcException xmlRpcException) {
                        // empty catch block
                    }
                }
            }.start();
        } else {
            new Thread(){

                public void run() {
                    Object object2 = null;
                    try {
                        object2 = object instanceof Object[] ? XmlRpcClient.this.invoke(string, (Object[])object) : XmlRpcClient.this.invoke(string, (List)object);
                        xmlRpcCallback.onResult(object2);
                    }
                    catch (XmlRpcException xmlRpcException) {
                        xmlRpcCallback.onException(xmlRpcException);
                    }
                    catch (XmlRpcFault xmlRpcFault) {
                        XmlRpcStruct xmlRpcStruct = (XmlRpcStruct)object2;
                        xmlRpcCallback.onFault(xmlRpcStruct.getInteger("faultCode"), xmlRpcStruct.getString("faultString"));
                    }
                }
            }.start();
        }
    }

    private void beginCall(String string) throws XmlRpcException {
        try {
            if (this.streamMessages) {
                this.openConnection();
                this.writer = new BufferedWriter(new OutputStreamWriter(this.connection.getOutputStream(), XmlRpcMessages.getString("XmlRpcClient.Encoding")));
            } else {
                ((StringWriter)this.writer).getBuffer().setLength(0);
            }
            this.writer.write("<?xml version=\"1.0\" encoding=\"");
            this.writer.write(XmlRpcMessages.getString("XmlRpcClient.Encoding"));
            this.writer.write("\"?>");
            this.writer.write("<methodCall><methodName>");
            this.writer.write(string);
            this.writer.write("</methodName><params>");
        }
        catch (IOException iOException) {
            throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcClient.NetworkError"), iOException);
        }
    }

    private Object endCall() throws XmlRpcException, XmlRpcFault {
        try {
            this.writer.write("</params>");
            this.writer.write("</methodCall>");
            if (this.streamMessages) {
                this.writer.flush();
            } else {
                StringBuffer stringBuffer = ((StringWriter)this.writer).getBuffer();
                this.openConnection();
                this.connection.setRequestProperty("Content-Length", String.valueOf(stringBuffer.length()));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.connection.getOutputStream());
                ((OutputStream)bufferedOutputStream).write(stringBuffer.toString().getBytes());
                ((OutputStream)bufferedOutputStream).flush();
                ((OutputStream)bufferedOutputStream).close();
            }
            this.handleResponse();
        }
        catch (IOException iOException) {
            throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcClient.NetworkError"), iOException);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {}
            this.connection.disconnect();
            this.connection = null;
        }
        return this.returnValue;
    }

    private void handleResponse() throws XmlRpcFault {
        try {
            this.parse(new BufferedInputStream(this.connection.getInputStream()));
        }
        catch (Exception exception) {
            throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcClient.ParseError"), exception);
        }
        if (this.isFaultResponse) {
            XmlRpcStruct xmlRpcStruct = (XmlRpcStruct)this.returnValue;
            this.isFaultResponse = false;
            throw new XmlRpcFault(xmlRpcStruct.getInteger("faultCode"), xmlRpcStruct.getString("faultString"));
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("fault")) {
            this.isFaultResponse = true;
        } else {
            super.startElement(string, string2, string3, attributes);
        }
    }

    protected void handleParsedValue(Object object) {
        this.returnValue = object;
    }

    private void openConnection() throws IOException {
        this.connection = (HttpURLConnection)this.url.openConnection();
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("POST");
        this.connection.setRequestProperty("Content-Type", "text/xml; charset=" + XmlRpcMessages.getString("XmlRpcClient.Encoding"));
        if (this.requestProperties != null) {
            Iterator iterator = this.requestProperties.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.connection.setRequestProperty(string, (String)this.requestProperties.get(string));
            }
        }
    }
}

