/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.JButton;

public class ButtonUtil {
    public static final int NO_PADDING = 0;
    public static final int LEFT_PADDING = 1;
    public static final int RIGHT_PADDING = 2;
    public static final int CENTER_PADDING = 3;
    public static final String CLIENT_PROPERTY_EQUALIZE = "buttonEqualize";
    private static final Dimension BUTTONS_HORIZONTAL_GAP = new Dimension(5, 0);
    private static final Dimension BUTTONS_VERTICAL_GAP = new Dimension(0, 0);

    private ButtonUtil() {
    }

    public static Box createHorizontalButtonBox(Component[] components, int paddingMode) {
        Box buttonBox = new Box(2);
        ButtonUtil.fillButtonBox(buttonBox, ButtonUtil.equalizeButtonsForHorizontalBox(components), Box.createHorizontalGlue(), paddingMode);
        return buttonBox;
    }

    public static Box createVerticalButtonBox(Component[] components, int paddingMode) {
        Box buttonBox = new Box(3);
        ButtonUtil.fillButtonBox(buttonBox, ButtonUtil.equalizeButtonsForVerticalBox(components), Box.createVerticalGlue(), paddingMode);
        return buttonBox;
    }

    private static void fillButtonBox(Box buttonBox, Component[] components, Component glue, int paddingMode) {
        if ((paddingMode & 1) != 0) {
            buttonBox.add(glue);
        }
        for (Component component : components) {
            buttonBox.add(component);
        }
        if ((paddingMode & 2) != 0) {
            buttonBox.add(glue);
        }
    }

    public static Component[] equalizeButtonsForVerticalBox(Component[] components) {
        return ButtonUtil.equalizeButtonsForBox(components, BUTTONS_VERTICAL_GAP);
    }

    public static Component[] equalizeButtonsForHorizontalBox(Component[] components) {
        return ButtonUtil.equalizeButtonsForBox(components, BUTTONS_HORIZONTAL_GAP);
    }

    private static Component[] equalizeButtonsForBox(Component[] components, Dimension gapDimension) {
        LinkedList<Component> newComponentList = new LinkedList<Component>();
        LinkedList<JButton> buttonList = new LinkedList<JButton>();
        int maxWidth = 0;
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof JButton) {
                Boolean equalize;
                JButton button = (JButton)component;
                if (button.getText() != null && !button.getText().isEmpty()) {
                    button.setPreferredSize(null);
                }
                if ((equalize = (Boolean)button.getClientProperty(CLIENT_PROPERTY_EQUALIZE)) == null || equalize.booleanValue()) {
                    maxWidth = Math.max(maxWidth, button.getPreferredSize().width);
                    buttonList.add(button);
                }
                if (i > 0) {
                    newComponentList.add(Box.createRigidArea(gapDimension));
                }
            }
            newComponentList.add(component);
        }
        for (JButton button : buttonList) {
            Dimension preferredSize = button.getPreferredSize();
            preferredSize.width = maxWidth;
            button.setPreferredSize(preferredSize);
            button.setMinimumSize(preferredSize);
            button.setMaximumSize(preferredSize);
        }
        return newComponentList.toArray(components);
    }
}

