/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration;

import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.macos.MacFileSystem;
import com.install4j.runtime.installer.platform.macos.MacLog;
import com.install4j.runtime.installer.platform.win32.Common;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.launcher.integration.LockFile;
import com.install4j.runtime.launcher.integration.UpdateLog;
import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SingleBundleUpdater {
    private static final String LOG_PREFIX = "UPDATER: ";

    public static void main(String[] args) {
        UpdateLog.setApplicationName("Single Bundle Updater");
        SingleBundleUpdater.log("starting");
        Common.init();
        File sourceBundle = new File(args[0]);
        File destinationBundle = new File(new File(args[1]), sourceBundle.getName());
        File currentSingleBundle = new File(args[2]);
        File backupDir = "null".equals(args[3]) ? null : new File(args[3]);
        boolean phase1 = Boolean.parseBoolean(args[4]);
        boolean restartLauncher = Boolean.parseBoolean(args[5]);
        List<String> launcherArguments = Arrays.asList(args).subList(6, args.length);
        try {
            if (phase1) {
                SingleBundleUpdater.phase1(sourceBundle, destinationBundle, backupDir, currentSingleBundle, restartLauncher, launcherArguments);
            } else {
                SingleBundleUpdater.phase2(destinationBundle, backupDir, currentSingleBundle, restartLauncher, launcherArguments);
            }
        }
        catch (Throwable t) {
            SingleBundleUpdater.log(t);
            System.out.println(System.getProperty("java.home"));
            System.exit(1);
        }
    }

    private static void phase1(File sourceBundle, File destinationBundle, File backupDir, File currentSingleBundle, boolean restartLauncher, List<String> launcherArguments) {
        SingleBundleUpdater.log("phase 1");
        if (!sourceBundle.getPath().endsWith(".app") || !destinationBundle.getPath().endsWith(".app")) {
            SingleBundleUpdater.log("wrong parameters " + sourceBundle.getPath() + ", " + destinationBundle.getPath());
            System.exit(1);
        }
        LockFile.waitForShutdownLockFile();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            SingleBundleUpdater.log(e);
        }
        boolean success = false;
        try {
            SingleBundleUpdater.moveBundle(sourceBundle, destinationBundle, backupDir);
            success = true;
            MacFileSystem.notifyBundleChange(destinationBundle);
        }
        catch (Throwable e) {
            SingleBundleUpdater.log(e);
        }
        SingleBundleUpdater.log("result phase 1: " + success + ", " + backupDir);
        if (success) {
            System.exit(0);
        } else {
            AutomaticUpdate.checkRegularExit(false, false);
            if (restartLauncher) {
                SingleBundleUpdater.restartLauncher(currentSingleBundle, launcherArguments);
            }
            SingleBundleUpdater.log("exiting");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void phase2(File destinationBundle, File backupDir, File currentSingleBundle, boolean restartLauncher, List<String> launcherArguments) {
        block22: {
            SingleBundleUpdater.log("phase 2");
            LockFile.deleteShutdownLockFile();
            SingleBundleUpdater.log("restart: " + restartLauncher);
            try {
                AutomaticUpdate.checkRegularExit(true, false);
                if (!restartLauncher) break block22;
                SingleBundleUpdater.restartLauncher(destinationBundle, launcherArguments);
            }
            catch (Throwable throwable) {
                try {
                    if (destinationBundle.getAbsolutePath().startsWith("/Applications/")) {
                        SingleBundleUpdater.log("changing group of " + destinationBundle.getAbsolutePath() + " to admin");
                        LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/sbin/chown")).arguments("-R", ":admin", destinationBundle.getAbsolutePath()).wait(false));
                    }
                }
                catch (Throwable t) {
                    SingleBundleUpdater.log(t);
                }
                boolean newBundleLocation = false;
                try {
                    boolean bl = newBundleLocation = currentSingleBundle != null && !destinationBundle.getCanonicalFile().equals(currentSingleBundle.getCanonicalFile());
                    if (newBundleLocation) {
                        SingleBundleUpdater.log("removing previous bundle at " + currentSingleBundle);
                        SingleBundleUpdater.deleteRecursive(currentSingleBundle);
                    }
                }
                catch (IOException e) {
                    SingleBundleUpdater.log(e);
                }
                if (backupDir != null) {
                    if (newBundleLocation) {
                        SingleBundleUpdater.log("keeping backup at " + backupDir + " because a different app was replaced");
                    } else {
                        SingleBundleUpdater.log("removing backup at " + backupDir);
                        SingleBundleUpdater.deleteRecursive(backupDir);
                        if (backupDir.exists()) {
                            SingleBundleUpdater.log("could not fully remove backup at " + backupDir);
                        }
                    }
                }
                SingleBundleUpdater.log("exiting");
                System.exit(0);
                throw throwable;
            }
        }
        try {
            if (destinationBundle.getAbsolutePath().startsWith("/Applications/")) {
                SingleBundleUpdater.log("changing group of " + destinationBundle.getAbsolutePath() + " to admin");
                LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/sbin/chown")).arguments("-R", ":admin", destinationBundle.getAbsolutePath()).wait(false));
            }
        }
        catch (Throwable t) {
            SingleBundleUpdater.log(t);
        }
        boolean newBundleLocation = false;
        try {
            boolean bl = newBundleLocation = currentSingleBundle != null && !destinationBundle.getCanonicalFile().equals(currentSingleBundle.getCanonicalFile());
            if (newBundleLocation) {
                SingleBundleUpdater.log("removing previous bundle at " + currentSingleBundle);
                SingleBundleUpdater.deleteRecursive(currentSingleBundle);
            }
        }
        catch (IOException e) {
            SingleBundleUpdater.log(e);
        }
        if (backupDir != null) {
            if (newBundleLocation) {
                SingleBundleUpdater.log("keeping backup at " + backupDir + " because a different app was replaced");
            } else {
                SingleBundleUpdater.log("removing backup at " + backupDir);
                SingleBundleUpdater.deleteRecursive(backupDir);
                if (backupDir.exists()) {
                    SingleBundleUpdater.log("could not fully remove backup at " + backupDir);
                }
            }
        }
        SingleBundleUpdater.log("exiting");
        System.exit(0);
    }

    private static void restartLauncher(File launchBundle, List<String> launcherArguments) {
        SingleBundleUpdater.log("launch bundle " + launchBundle);
        if (launchBundle != null) {
            ArrayList<String> command = new ArrayList<String>();
            command.add("/usr/bin/open");
            command.add(launchBundle.getAbsolutePath());
            if (!launcherArguments.isEmpty()) {
                command.add("--args");
                command.addAll(launcherArguments);
            }
            try {
                new ProcessBuilder(command).start();
            }
            catch (IOException e) {
                SingleBundleUpdater.log(e);
            }
        }
    }

    private static void moveBundle(File sourceBundle, File destinationBundle, File backupDir) throws IOException, InterruptedException {
        SingleBundleUpdater.doBackup(destinationBundle, backupDir);
        SingleBundleUpdater.log("moving bundle from " + sourceBundle + " to " + destinationBundle);
        try {
            try {
                SingleBundleUpdater.executeMove(false, sourceBundle, destinationBundle, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                SingleBundleUpdater.executeMove(true, sourceBundle, destinationBundle, new StandardCopyOption[0]);
            }
        }
        catch (Throwable t) {
            SingleBundleUpdater.restoreBackup(backupDir, destinationBundle);
            throw t;
        }
    }

    private static void restoreBackup(File backupDir, File destinationBundle) {
        if (backupDir != null) {
            SingleBundleUpdater.log("restoring backup from " + backupDir + " to " + destinationBundle);
            SingleBundleUpdater.deleteRecursive(destinationBundle);
            try {
                try {
                    SingleBundleUpdater.executeMove(false, backupDir, destinationBundle, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException e) {
                    SingleBundleUpdater.executeMove(false, backupDir, destinationBundle, new StandardCopyOption[0]);
                }
            }
            catch (Throwable t2) {
                SingleBundleUpdater.log(t2);
            }
        }
    }

    private static void executeMove(boolean fallbackToCopy, File sourceBundle, File destinationBundle, StandardCopyOption ... copyOptions) throws IOException {
        try {
            Files.move(sourceBundle.toPath(), destinationBundle.toPath(), copyOptions);
        }
        catch (IOException e) {
            if (fallbackToCopy) {
                SingleBundleUpdater.log("fallback to copy for move from " + sourceBundle + " to " + destinationBundle);
                destinationBundle.mkdirs();
                SingleBundleUpdater.copyDirectory(sourceBundle, destinationBundle);
            }
            throw e;
        }
    }

    private static void copyDirectory(File sourceDir, File targetDir) throws IOException {
        File[] files = sourceDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            File sourceFile = new File(sourceDir, file.getName()).getCanonicalFile();
            File targetFile = new File(targetDir, sourceFile.getName());
            if (sourceFile.isDirectory()) {
                if (!targetFile.exists() && !targetFile.mkdirs()) {
                    throw new IOException("Cannot create " + targetDir.getPath());
                }
                SingleBundleUpdater.copyDirectory(sourceFile, targetFile);
                continue;
            }
            Files.copy(sourceFile.toPath(), targetFile.toPath(), new CopyOption[0]);
        }
    }

    private static void doBackup(File destinationBundle, File backupDir) throws IOException {
        if (backupDir != null && destinationBundle.exists()) {
            SingleBundleUpdater.log("backing up " + destinationBundle + " to " + backupDir);
            try {
                SingleBundleUpdater.executeMove(false, destinationBundle, backupDir, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AtomicMoveNotSupportedException e) {
                SingleBundleUpdater.executeMove(false, destinationBundle, backupDir, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static void deleteRecursive(File file) {
        if (!file.getPath().endsWith(".app")) {
            SingleBundleUpdater.log("did not execute delete for " + file.getPath());
        } else {
            SingleBundleUpdater.deleteRecursiveInt(file);
        }
    }

    private static void deleteRecursiveInt(File file) {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                SingleBundleUpdater.deleteRecursiveInt(child);
            }
        }
        file.delete();
    }

    private static void log(String message) {
        UpdateLog.log(5, message);
        MacLog.log(LOG_PREFIX + message);
    }

    private static void log(Throwable e) {
        UpdateLog.log(e);
        MacLog.log(LOG_PREFIX, e);
    }
}

