/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.update.UpdateChecker;
import com.install4j.runtime.beans.actions.update.ShutdownCallingLauncherAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.helper.launching.OutputRedirection;
import com.install4j.runtime.installer.helper.launching.OutputRedirectionMode;
import com.install4j.runtime.installer.platform.macos.MacAuthorization;
import com.install4j.runtime.installer.platform.macos.VolumeInfo;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.launcher.LauncherVariables;
import com.install4j.runtime.launcher.integration.LockFile;
import com.install4j.runtime.launcher.integration.UpdateConfig;
import com.install4j.runtime.launcher.integration.UpdateExecutionConfig;
import com.install4j.runtime.launcher.integration.UpdateLog;
import com.install4j.runtime.launcher.util.SingleInstance;
import com.install4j.runtime.util.Base64;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutomaticUpdate {
    private static final String PROPNAME_UPDATE_DIR = "install4j.updateStorageDir";
    private static volatile File updateDir;

    public static File getUpdateDir() {
        if (updateDir == null) {
            String updateDirName = System.getProperty(PROPNAME_UPDATE_DIR);
            if (updateDirName != null) {
                updateDir = new File(updateDirName);
            } else {
                String applicationId = AutomaticUpdate.getApplicationId();
                if (applicationId == null) {
                    applicationId = "unknown";
                }
                updateDir = new File(new File(AutomaticUpdate.getUpdateBaseDir(), Base64.encodeForFiles(applicationId)), SingleInstance.getPathHash(ResourceHelper.getRuntimeDir(), ""));
            }
        }
        return updateDir;
    }

    @NotNull
    private static File getUpdateBaseDir() {
        return new File(InstallerVariables.getInstall4jCacheDir(), "update");
    }

    public static boolean isScheduled(String version, boolean checkTimeInhibition, boolean checkInstalledVersion) {
        boolean[] ret = new boolean[1];
        UpdateConfig.withConfig(false, updateConfig -> {
            boolean bl = ret[0] = !(version != null && !version.equals(updateConfig.getVersion()) || !AutomaticUpdate.shouldBeExecuted(updateConfig, true) || checkTimeInhibition && !AutomaticUpdate.isNoTimeInhibition(updateConfig, updateConfig.getFile(), "scheduled"));
            if (checkInstalledVersion && ret[0] && AutomaticUpdate.isAlreadyUpdatedManually(updateConfig)) {
                ret[0] = false;
                updateConfig.setSuccess(true);
                return true;
            }
            return false;
        });
        return ret[0];
    }

    private static boolean isAlreadyUpdatedManually(UpdateConfig updateConfig) {
        String installedVersion = AutomaticUpdate.getInstalledVersion();
        String updateVersion = updateConfig.getVersion();
        return Objects.equals(updateVersion, installedVersion) || updateConfig.isCheckNewerVersion() && UpdateChecker.isVersionLessThanOrEqual(updateVersion, installedVersion);
    }

    @Nullable
    private static String getInstalledVersion() {
        ContextInt singleContextInt = ContextImpl.getSingleContextInt();
        if (singleContextInt != null) {
            return singleContextInt.getVersion();
        }
        try {
            return LauncherVariables.getApplicationVersion();
        }
        catch (IOException e) {
            UpdateLog.log(e);
            e.printStackTrace();
            return null;
        }
    }

    private static boolean shouldBeExecuted(UpdateConfig updateConfig, boolean scheduleCheck) {
        String verb = scheduleCheck ? "scheduled" : "started";
        String fileName = updateConfig.getFile();
        if (!updateConfig.isSuccess() && fileName != null && !fileName.isEmpty() && new File(fileName).exists()) {
            if (updateConfig.getTryCount() < updateConfig.getMaxTries()) {
                if (updateConfig.getCancelCount() < updateConfig.getMaxCancelCount()) {
                    return true;
                }
                UpdateLog.log(2, "update not " + verb + " because of maximum cancel count");
            } else {
                UpdateLog.log(2, "update not " + verb + " because of maximum retry count");
            }
        }
        return false;
    }

    public static void cleanupAllSuccessfulInstallations(@Nullable String currentInstallerPath) {
        File[] appIdDirs = AutomaticUpdate.getUpdateBaseDir().listFiles();
        if (appIdDirs != null) {
            for (File appIdDir : appIdDirs) {
                File[] pathDirs;
                if (!appIdDir.isDirectory() || (pathDirs = appIdDir.listFiles()) == null) continue;
                for (File pathDir : pathDirs) {
                    if (!pathDir.isDirectory()) continue;
                    UpdateLog.log(10, "checking " + pathDir + " for cleanup");
                    UpdateConfig.withConfig(new File(pathDir, "config.xml"), false, updateConfig -> {
                        UpdateLog.log(10, "checking " + pathDir + " for cleanup");
                        if (updateConfig.isSuccess() && !Objects.equals(updateConfig.getFile(), currentInstallerPath)) {
                            return AutomaticUpdate.deleteInstaller(updateConfig);
                        }
                        return false;
                    });
                }
            }
        }
    }

    private static boolean deleteInstaller(UpdateConfig updateConfig) {
        String fileName = updateConfig.getFile();
        if (!fileName.isEmpty()) {
            boolean tryDelete = true;
            if (Util.isMacOS() && fileName.endsWith(".dmg")) {
                for (Map.Entry<String, String> entry : VolumeInfo.getMountPointToDiskFile().entrySet()) {
                    if (!Objects.equals(fileName, entry.getValue()) || VolumeInfo.detach(new File(entry.getKey()))) continue;
                    UpdateLog.log(2, "could not detach " + fileName);
                    tryDelete = false;
                }
            }
            if (tryDelete) {
                File file = new File(fileName);
                file.delete();
                if (!file.isFile()) {
                    UpdateLog.log(2, "deleted " + fileName);
                    updateConfig.clear();
                    return true;
                }
                UpdateLog.log(2, "could not delete " + fileName);
            }
        }
        return false;
    }

    private static boolean isConfigWithContent() {
        boolean[] ret = new boolean[1];
        UpdateConfig.withConfig(false, updateConfig -> {
            ret[0] = !updateConfig.getFile().isEmpty() && !updateConfig.getVersion().isEmpty();
            return false;
        });
        return ret[0];
    }

    public static void checkUpdates(String[] launcherArguments, UpdateExecutionConfig updateExecutionConfig, boolean restartLauncher, Runnable shutdownRunnable) {
        boolean shutdown = false;
        boolean configWithContent = AutomaticUpdate.isConfigWithContent();
        UpdateLog.log(20, "checking update: " + configWithContent);
        if (configWithContent) {
            try (Closeable initLock = LockFile.tryInitLock();){
                if (initLock != null) {
                    UpdateConfig.withConfig(false, updateConfig -> {
                        String fileName = updateConfig.getFile();
                        String version = updateConfig.getVersion();
                        UpdateLog.log(5, "checking update installation. File: " + fileName + ", Version: " + version);
                        if (!fileName.isEmpty() && !version.isEmpty()) {
                            if (AutomaticUpdate.shouldBeExecuted(updateConfig, false)) {
                                if (AutomaticUpdate.isNoTimeInhibition(updateConfig, fileName, "started") && !Objects.equals(version, AutomaticUpdate.getInstalledVersion())) {
                                    updateExecutionConfig.setInstallerFile(new File(fileName));
                                    updateExecutionConfig.setLanguageId(updateConfig.getLanguageId());
                                    updateExecutionConfig.setInstallationDirectory(updateConfig.getInstallationDirectory());
                                    updateExecutionConfig.getArguments().addAll(updateConfig.getArguments());
                                    updateConfig.setTryCount(updateConfig.getTryCount() + 1);
                                    updateConfig.setInstallTimestamp(System.currentTimeMillis());
                                    return true;
                                }
                            } else if ((updateConfig.isSuccess() || AutomaticUpdate.isNoTimeInhibition(updateConfig, fileName, "deleted")) && AutomaticUpdate.deleteInstaller(updateConfig)) {
                                return true;
                            }
                        }
                        return false;
                    });
                    if (updateExecutionConfig.getInstallerFile() != null && updateExecutionConfig.getInstallerFile().exists()) {
                        if (updateExecutionConfig.getUnattendedUpdateTitle() != null && !updateExecutionConfig.getUnattendedUpdateTitle().isEmpty()) {
                            LauncherVariables.setLanguageId(updateExecutionConfig.getLanguageId());
                            updateExecutionConfig.setUnattendedUpdateTitle(LauncherVariables.replaceVariables(updateExecutionConfig.getUnattendedUpdateTitle()));
                        }
                        try {
                            UpdateLog.log(1, "starting update " + updateExecutionConfig.getInstallerFile());
                            Process process = AutomaticUpdate.doUpdate(updateExecutionConfig, restartLauncher, launcherArguments);
                            if (process != null) {
                                LockFile.waitForInstallerLock(process);
                            }
                            shutdown = true;
                        }
                        catch (Exception e) {
                            UpdateLog.log(e);
                            e.printStackTrace();
                        }
                    }
                } else {
                    UpdateLog.log(5, "could not acquire init lock");
                }
            }
            catch (IOException e) {
                UpdateLog.log(e);
                e.printStackTrace();
            }
        }
        if (shutdown) {
            if (shutdownRunnable != null) {
                shutdownRunnable.run();
            } else {
                Context context = ContextImpl.getCurrentContext();
                if (context != null) {
                    context.finish(0);
                }
                System.exit(0);
            }
        }
    }

    private static boolean isNoTimeInhibition(@NotNull UpdateConfig updateConfig, @NotNull String file, String actionVerb) {
        boolean noTimeInhibition;
        boolean archive = Util.isMacOS() && !file.isEmpty() && new File(file).isDirectory();
        int retryInhibitionMinutes = AutomaticUpdate.getRetryInhibitionMinutes(updateConfig, archive);
        boolean bl = noTimeInhibition = System.currentTimeMillis() > updateConfig.getInstallTimestamp() + TimeUnit.MINUTES.toMillis(retryInhibitionMinutes);
        if (!noTimeInhibition) {
            UpdateLog.log(2, "update not " + actionVerb + " because of retry time inhibition");
        }
        return noTimeInhibition;
    }

    private static int getRetryInhibitionMinutes(@NotNull UpdateConfig updateConfig, boolean archive) {
        int retryInhibitionMinutes = updateConfig.getRetryInhibitionMinutes();
        if (archive && (updateConfig.getCancelTimestamp() == 0L || updateConfig.getCancelTimestamp() < updateConfig.getInstallTimestamp())) {
            retryInhibitionMinutes = 1440;
        }
        return Integer.getInteger("install4j.updateRetryInhibition", retryInhibitionMinutes);
    }

    private static Process doUpdate(UpdateExecutionConfig updateExecutionConfig, boolean restartLauncher, String[] launcherArguments) throws IOException, MacAuthorization.BaseAuthorizationException {
        Context context = ContextImpl.getCurrentContext();
        if (context != null) {
            ShutdownCallingLauncherAction.shutdownCallingLauncher(context, true, 120);
        }
        if (AutomaticUpdate.handleMacosArchive(updateExecutionConfig, restartLauncher, launcherArguments)) {
            return null;
        }
        return AutomaticUpdate.executeInstaller(updateExecutionConfig, restartLauncher, launcherArguments);
    }

    private static boolean isAdminWritable(File file) {
        try {
            Path path = file.toPath();
            Set<PosixFilePermission> posixFilePermissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
            return posixFilePermissions.contains((Object)PosixFilePermission.OTHERS_WRITE) || posixFilePermissions.contains((Object)PosixFilePermission.GROUP_WRITE) && Files.readAttributes(path, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS).group().getName().equals("admin") || Files.getOwner(path, LinkOption.NOFOLLOW_LINKS).getName().equals(System.getProperty("user.name")) && posixFilePermissions.contains((Object)PosixFilePermission.OWNER_WRITE);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean handleMacosArchive(UpdateExecutionConfig updateExecutionConfig, boolean restartLauncher, String[] launcherArguments) throws IOException, MacAuthorization.BaseAuthorizationException {
        if (Util.isMacOS() && updateExecutionConfig.getInstallerFile().isDirectory()) {
            File[] files = updateExecutionConfig.getInstallerFile().listFiles(pathname -> pathname.isDirectory() && pathname.getName().endsWith(".app"));
            if (files != null && files.length == 1) {
                File destinationBundle;
                File sourceAppDir = files[0];
                String installationDirectory = updateExecutionConfig.getInstallationDirectory();
                File currentSingleBundle = AutomaticUpdate.getCurrentSingleBundle();
                boolean authorize = false;
                if (Boolean.getBoolean("install4j.backgroundUpdateAdmin")) {
                    authorize = true;
                } else if (!installationDirectory.startsWith(System.getProperty("user.home"))) {
                    if (Util.isAdminGroup()) {
                        destinationBundle = new File(installationDirectory, sourceAppDir.getName());
                        authorize = !AutomaticUpdate.isAdminWritable(currentSingleBundle) || destinationBundle.exists() && !AutomaticUpdate.isAdminWritable(destinationBundle) || !AutomaticUpdate.isAdminWritable(new File(installationDirectory));
                    } else {
                        authorize = true;
                    }
                }
                destinationBundle = FileUtil.getCanonicalFile(new File(installationDirectory, sourceAppDir.getName()));
                File backupDir = destinationBundle.exists() ? FileUtil.getCanonicalFile(AutomaticUpdate.getNonExistingBackupDir(destinationBundle.getParentFile(), destinationBundle.getName())) : null;
                File currentExecutable = new File(ResourceHelper.getRuntimeDir(), "singleBundleAutoUpdater");
                List<String> phase1 = AutomaticUpdate.getSingleBundleUpdaterCommand(restartLauncher, launcherArguments, sourceAppDir, installationDirectory, currentSingleBundle, backupDir, currentExecutable, true);
                File phase2Executable = currentExecutable;
                if (backupDir != null && currentExecutable.getAbsolutePath().startsWith(destinationBundle.getAbsolutePath())) {
                    phase2Executable = new File(backupDir, currentExecutable.getAbsolutePath().substring(destinationBundle.getAbsolutePath().length() + 1));
                }
                List<String> phase2 = AutomaticUpdate.getSingleBundleUpdaterCommand(restartLauncher, launcherArguments, sourceAppDir, installationDirectory, currentSingleBundle, backupDir, phase2Executable, false);
                String redirectionFile = System.getProperty("install4j.singleBundleAutoUpdaterRedirection", "/dev/null");
                StringBuilder shellCommand = new StringBuilder();
                AutomaticUpdate.appendCommand(phase1, shellCommand);
                shellCommand.append(" > \"").append(redirectionFile).append("\" 2>&1 && ");
                AutomaticUpdate.appendCommand(phase2, shellCommand);
                shellCommand.append(" >> \"").append(redirectionFile).append("\" 2>&1");
                List<String> shellArguments = Arrays.asList("-c", shellCommand.toString());
                if (authorize) {
                    try {
                        MacAuthorization.execute(MacAuthorization.getDefaultPrompt(AutomaticUpdate.getApplicationName()), "/bin/sh", shellArguments);
                    }
                    catch (MacAuthorization.BaseAuthorizationException e) {
                        UpdateConfig.withConfig(false, updateConfig -> {
                            int cancelCount = updateConfig.getCancelCount();
                            updateConfig.setCancelCount(cancelCount + 1);
                            if (cancelCount < updateConfig.getMaxCancelCount()) {
                                updateConfig.setTryCount(updateConfig.getTryCount() - 1);
                            }
                            return true;
                        });
                    }
                } else {
                    LaunchHelper.launchApplication(new LaunchDescriptor(new File("/bin/sh")).arguments(shellArguments).wait(false));
                }
            }
            return true;
        }
        return false;
    }

    private static void appendCommand(List<String> command, Appendable appendable) throws IOException {
        for (int i = 0; i < command.size(); ++i) {
            if (i > 0) {
                appendable.append(" ");
            }
            appendable.append("\"");
            appendable.append(command.get(i));
            appendable.append("\"");
        }
    }

    @NotNull
    private static List<String> getSingleBundleUpdaterCommand(boolean restartLauncher, String[] launcherArguments, File sourceAppDir, String installationDirectory, File currentSingleBundle, File backupDir, File executable, boolean phase1) {
        ArrayList<String> vmOptions = new ArrayList<String>();
        LockFile.addShutdownLockFile(vmOptions);
        UpdateLog.addUpdateLogProperty(vmOptions);
        vmOptions.add("-Dinstall4j.updateStorageDir=" + AutomaticUpdate.getUpdateDir());
        ArrayList<String> command = new ArrayList<String>();
        command.add(executable.getAbsolutePath());
        vmOptions.forEach(option -> command.add("-J" + option));
        command.add(sourceAppDir.getAbsolutePath());
        command.add(installationDirectory);
        command.add(FileUtil.getCanonicalPath(currentSingleBundle));
        command.add(String.valueOf(backupDir));
        command.add(String.valueOf(phase1));
        command.add(String.valueOf(restartLauncher));
        if (launcherArguments != null) {
            command.addAll(Arrays.asList(launcherArguments));
        }
        return command;
    }

    private static File getNonExistingBackupDir(File directory, String baseName) {
        File result = null;
        for (int index = 1; index < 1000000 && (result == null || result.exists()); ++index) {
            result = new File(directory, "." + index + "." + baseName);
        }
        return result;
    }

    private static Process executeInstaller(UpdateExecutionConfig updateExecutionConfig, boolean restartLauncher, String[] launcherArguments) {
        String stdoutRedirectionFile;
        LaunchDescriptor launchDescriptor = new LaunchDescriptor(updateExecutionConfig.getInstallerFile());
        launchDescriptor.arguments(AutomaticUpdate.getInstallerArguments(updateExecutionConfig, restartLauncher, launcherArguments));
        launchDescriptor.specificEnvironmentVariables(Collections.singletonMap("INSTALL4J_JAVA_HOME", System.getProperty("java.home")));
        launchDescriptor.attachWithNoBrowse(true);
        launchDescriptor.useNohup(!Util.isWindows() && !Util.isMacOS());
        String stderrRedirectionFile = System.getProperty("install4j.backgroundInstallerStderrLog");
        if (stderrRedirectionFile != null) {
            launchDescriptor.stderrRedirection(new OutputRedirection(OutputRedirectionMode.FILE, "", false, new File(stderrRedirectionFile), false));
        }
        if ((stdoutRedirectionFile = System.getProperty("install4j.backgroundInstallerStdoutLog")) != null) {
            launchDescriptor.stdoutRedirection(new OutputRedirection(OutputRedirectionMode.FILE, "", false, new File(stdoutRedirectionFile), false));
        }
        launchDescriptor.receiveProcess(true);
        LaunchHelper.launchApplication(launchDescriptor);
        return launchDescriptor.getProcess();
    }

    private static List<String> getInstallerArguments(UpdateExecutionConfig updateExecutionConfig, boolean restartLauncher, String[] launcherArguments) {
        String launchInfoPath;
        ArrayList<String> arguments = new ArrayList<String>();
        if (updateExecutionConfig.getExecutionMode() != null) {
            arguments.addAll(updateExecutionConfig.getExecutionMode().getArguments(updateExecutionConfig.getUnattendedUpdateTitle()));
        }
        arguments.addAll(updateExecutionConfig.getArguments());
        if (updateExecutionConfig.getLanguageId() != null && !updateExecutionConfig.getLanguageId().isEmpty()) {
            arguments.add("-Duser.language=" + updateExecutionConfig.getLanguageId());
            arguments.add("-Dinstall4j.language=" + updateExecutionConfig.getLanguageId());
        }
        if (updateExecutionConfig.getInstallationDirectory() != null && !updateExecutionConfig.getInstallationDirectory().isEmpty()) {
            arguments.add("-dir");
            arguments.add(updateExecutionConfig.getInstallationDirectory());
        }
        if (restartLauncher && (launchInfoPath = AutomaticUpdate.getLaunchInfoPath(launcherArguments)) != null) {
            arguments.add("-Dinstall4j.launchInfoFile=" + launchInfoPath);
        }
        LockFile.addShutdownLockFile(arguments);
        UpdateLog.addUpdateLogProperty(arguments);
        arguments.add("-Dinstall4j.updateStorageDir=" + AutomaticUpdate.getUpdateDir());
        arguments.add("-Vsys.automaticUpdate=true");
        return arguments;
    }

    public static File getCurrentSingleBundle() {
        File installationDir;
        String dirName;
        File runtimeDir;
        if (Util.isMacOS() && (runtimeDir = ResourceHelper.getRuntimeDir()) != null && (dirName = FileUtil.getCanonicalPath(installationDir = runtimeDir.getParentFile())).toLowerCase(Locale.ENGLISH).endsWith("Contents/Resources/app".toLowerCase(Locale.ENGLISH))) {
            return new File(dirName.substring(0, dirName.length() - "Contents/Resources/app".length()));
        }
        return null;
    }

    private static String getLaunchInfoPath(String[] launcherArguments) {
        String launcherPath = null;
        if (ContextImpl.getCurrentContext() == null || InstallerUtil.isInProcess()) {
            if (!Launcher.isService()) {
                launcherPath = System.getProperty("exe4j.moduleName");
            }
        } else if (!Boolean.getBoolean("install4j.fromService")) {
            launcherPath = System.getProperty("install4j.fromLauncher");
        }
        String launchInfoPath = null;
        if (launcherPath != null) {
            try {
                File launchInfoFile = File.createTempFile("launch", ".tmp", AutomaticUpdate.getUpdateDir());
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(Files.newOutputStream(launchInfoFile.toPath(), new OpenOption[0])), StandardCharsets.UTF_8));){
                    pw.println(launcherPath);
                    if (launcherArguments != null) {
                        for (String launcherArgument : launcherArguments) {
                            pw.println(launcherArgument);
                        }
                    }
                }
                launchInfoPath = launchInfoFile.getAbsolutePath();
            }
            catch (IOException e) {
                UpdateLog.log(e);
                e.printStackTrace();
            }
        }
        return launchInfoPath;
    }

    private static String getApplicationId() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig == null) {
            try {
                return LauncherVariables.getApplicationId();
            }
            catch (IOException e) {
                UpdateLog.log(e);
                e.printStackTrace();
                return null;
            }
        }
        return installerConfig.getApplicationId();
    }

    public static String getApplicationName() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig == null) {
            try {
                return LauncherVariables.getApplicationName();
            }
            catch (IOException e) {
                UpdateLog.log(e);
                e.printStackTrace();
                return null;
            }
        }
        return installerConfig.getApplicationName();
    }

    public static void checkAutoUpdateLauncher() {
        File launchInfoFile;
        String launchInfoName;
        if (InstallerVariables.getBooleanVariable("sys.automaticUpdate") && (launchInfoName = System.getProperty("install4j.launchInfoFile")) != null && (launchInfoFile = new File(launchInfoName)).isFile()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(Files.newInputStream(launchInfoFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                ArrayList<String> arguments = new ArrayList<String>();
                String executableName = reader.readLine();
                if (executableName != null) {
                    File executableFile = new File(executableName);
                    if (executableFile.exists()) {
                        String argument = reader.readLine();
                        while (argument != null) {
                            arguments.add(argument);
                            argument = reader.readLine();
                        }
                    }
                    LaunchHelper.launchFinishExecutable(executableFile, arguments.toArray(new String[0]), executableFile.getParentFile(), ExecutionContext.UNELEVATED);
                }
            }
            catch (IOException e) {
                UpdateLog.log(e);
                Logger.getInstance().log(e);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!launchInfoFile.delete()) {
                launchInfoFile.deleteOnExit();
            }
        }
    }

    public static void checkRegularExit(boolean success, boolean cancelling) {
        if (success || cancelling) {
            UpdateConfig.withConfig(false, updateConfig -> {
                if (success) {
                    updateConfig.setSuccess(true);
                } else {
                    int cancelCount = updateConfig.getCancelCount();
                    updateConfig.setCancelCount(cancelCount + 1);
                    if (cancelCount < updateConfig.getMaxCancelCount()) {
                        updateConfig.setTryCount(updateConfig.getTryCount() - 1);
                    }
                }
                return true;
            });
        }
    }
}

