/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.flatlaf;

import com.ejt.internal.gui.CommonLookAndFeelUtil;
import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.IntelliJTheme;
import com.formdev.flatlaf.util.NativeLibrary;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import com.install4j.api.Util;
import com.install4j.api.laf.IndeterminateStateComponent;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.InstallerLookAndFeelConfig;
import com.install4j.runtime.installer.config.laf.DarkModeStrategy;
import com.install4j.runtime.installer.config.laf.FlatLafDarkTheme;
import com.install4j.runtime.installer.config.laf.FlatLafLightTheme;
import com.install4j.runtime.installer.frontend.ExtendedLookAndFeelHandler;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class FlatLafLookAndFeelHandler
implements ExtendedLookAndFeelHandler {
    private FlatLaf lookAndFeel;

    @Override
    public void applyLookAndFeel(boolean darkDesktop) throws Exception {
        InstallerLookAndFeelConfig lafConfig = InstallerConfig.getCurrentInstance().getLookAndFeelConfig();
        boolean darkMode = this.isDarkModeUsed(lafConfig.getDarkModeStrategy(), darkDesktop);
        this.lookAndFeel = this.createLookAndFeel(darkMode);
        UIManager.setLookAndFeel((LookAndFeel)this.lookAndFeel);
        CommonLookAndFeelUtil.adjustDefaultFont(UIScale.getUserScaleFactor());
    }

    @Override
    public boolean isDarkModeSwitchingSupported() {
        return true;
    }

    @Override
    public void setDark(boolean dark) {
        if (this.lookAndFeel.isDark() == dark) {
            return;
        }
        FlatLaf oldLookAndFeel = this.lookAndFeel;
        try {
            FlatLaf lookAndFeel;
            this.lookAndFeel = lookAndFeel = this.createLookAndFeel(dark);
            UIManager.setLookAndFeel((LookAndFeel)lookAndFeel);
        }
        catch (Exception e) {
            this.lookAndFeel = oldLookAndFeel;
            Util.logError(null, dark ? "Error switch to dark mode" : "Error switching to light mode");
            Util.log(e);
            e.printStackTrace();
        }
    }

    @Override
    public boolean isDark() {
        return this.lookAndFeel != null && this.lookAndFeel.isDark();
    }

    @Override
    public boolean isWideTreeSelection() {
        return UIManager.getBoolean("Tree.wideSelection");
    }

    @Override
    @NotNull
    public JCheckBox createTriStateCheckBox() {
        return new FlatLafTriStateCheckBox();
    }

    @Override
    public void disableExtraSelectionPainting(JTree tree) {
        tree.putClientProperty("JTree.paintSelection", false);
    }

    @Override
    public float getCustomScaleFactor() {
        return UIScale.getUserScaleFactor();
    }

    @Override
    public float computeFontScaleFactor(Font font) {
        return UIScale.computeFontScaleFactor((Font)font);
    }

    @Override
    public boolean isMacosFullWindowSupported() {
        return Util.isMacOS() && SystemInfo.isMacFullWindowContentSupported;
    }

    @Override
    public void enableMacosFullWindow(JRootPane rootPane) {
        if (this.isMacosFullWindowSupported()) {
            rootPane.putClientProperty("apple.awt.fullWindowContent", true);
            rootPane.putClientProperty("apple.awt.transparentTitleBar", true);
        }
    }

    @NotNull
    private FlatLaf createLookAndFeel(boolean darkMode) throws IOException {
        String preferredFontFamily;
        InstallerLookAndFeelConfig lafConfig = InstallerConfig.getCurrentInstance().getLookAndFeelConfig();
        int uiScalingPercentage = lafConfig.getUiScalingPercentage();
        if (uiScalingPercentage != 100) {
            System.setProperty("flatlaf.uiScale", uiScalingPercentage + "%");
            System.setProperty("flatlaf.uiScale.allowScaleDown", "true");
        }
        if ((preferredFontFamily = CommonLookAndFeelUtil.getPreferredFontFamily()) != null) {
            FlatLaf.setPreferredFontFamily((String)preferredFontFamily);
        }
        if (darkMode) {
            FlatLafDarkTheme theme = lafConfig.getDarkTheme();
            switch (theme) {
                case DARK: {
                    return new FlatDarkLaf();
                }
                case DARCULA: {
                    return new FlatDarculaLaf();
                }
                case CUSTOM: {
                    return this.loadTheme(lafConfig.getCustomDarkThemeName());
                }
            }
            throw new IllegalStateException(theme.name());
        }
        FlatLafLightTheme theme = lafConfig.getLightTheme();
        switch (theme) {
            case LIGHT: {
                return new FlatLightLaf();
            }
            case LIGHT_INTELLIJ: {
                return new FlatIntelliJLaf();
            }
            case CUSTOM: {
                return this.loadTheme(lafConfig.getCustomLightThemeName());
            }
        }
        throw new IllegalStateException(theme.name());
    }

    private boolean isDarkModeUsed(DarkModeStrategy darkModeStrategy, boolean darkDesktop) {
        switch (darkModeStrategy) {
            case AUTO_DETECT: {
                return darkDesktop;
            }
            case ALWAYS_LIGHT: {
                return false;
            }
            case ALWAYS_DARK: {
                return true;
            }
        }
        throw new IllegalStateException(darkModeStrategy.name());
    }

    @NotNull
    private FlatLaf loadTheme(String themeName) throws IOException {
        return IntelliJTheme.createLaf((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/" + themeName)));
    }

    private static final class PlaceHolderNativeLibrary
    extends NativeLibrary {
        public PlaceHolderNativeLibrary() {
            super("java", false);
        }

        public boolean isLoaded() {
            return true;
        }
    }

    private static class FlatLafTriStateCheckBox
    extends JCheckBox
    implements IndeterminateStateComponent {
        private FlatLafTriStateCheckBox() {
        }

        @Override
        public void setIndeterminate(boolean indeterminate) {
            this.putClientProperty("JButton.selectedState", indeterminate ? "indeterminate" : null);
        }

        @Override
        public void setSelected(boolean selected) {
            this.setIndeterminate(false);
            super.setSelected(selected);
        }
    }
}

