/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSCJavaToByteArrayConverter {
    private ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private byte[] intBytes = new byte[4];
    private byte[] longintBytes = new byte[8];

    private byte[] alignBigEndToFourByteBoundry(byte[] bytes) {
        int mod = bytes.length % 4;
        if (mod == 0) {
            return bytes;
        }
        int pad = 4 - mod;
        byte[] newBytes = new byte[pad + bytes.length];
        System.arraycopy(bytes, 0, newBytes, pad, bytes.length);
        return newBytes;
    }

    public void appendNullCharToAlignStream() {
        int mod = this.stream.size() % 4;
        int pad = 4 - mod;
        for (int i = 0; i < pad; ++i) {
            this.stream.write(0);
        }
    }

    public byte[] toByteArray() {
        return this.stream.toByteArray();
    }

    public void write(byte[] bytes) {
        this.writeUnderHandler(bytes);
    }

    public void write(int i) {
        this.writeInteger32ToByteArray(i);
    }

    public void write(Float f) {
        this.writeInteger32ToByteArray(Float.floatToIntBits(f.floatValue()));
    }

    public void write(Integer i) {
        this.writeInteger32ToByteArray(i);
    }

    public void write(BigInteger i) {
        this.writeInteger64ToByteArray(i.longValue());
    }

    public void write(String aString) {
        byte[] stringBytes = aString.getBytes();
        int mod = aString.length() % 4;
        int pad = 4 - mod;
        byte[] newBytes = new byte[pad + stringBytes.length];
        System.arraycopy(stringBytes, 0, newBytes, 0, stringBytes.length);
        try {
            this.stream.write(newBytes);
        }
        catch (IOException e) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream", e);
        }
    }

    public void write(char c) {
        this.stream.write(c);
    }

    public void write(Object anObject) {
        if (null != anObject) {
            if (anObject instanceof Object[]) {
                Object[] theArray = (Object[])anObject;
                for (int i = 0; i < theArray.length; ++i) {
                    this.write(theArray[i]);
                }
            } else if (anObject instanceof Float) {
                this.write((Float)anObject);
            } else if (anObject instanceof String) {
                this.write((String)anObject);
            } else if (anObject instanceof Integer) {
                this.write((Integer)anObject);
            } else if (anObject instanceof BigInteger) {
                this.write((BigInteger)anObject);
            }
        }
    }

    public void writeType(Class c) {
        if (Integer.class.equals((Object)c)) {
            this.stream.write(105);
        } else if (BigInteger.class.equals((Object)c)) {
            this.stream.write(104);
        } else if (Float.class.equals((Object)c)) {
            this.stream.write(102);
        } else if (Double.class.equals((Object)c)) {
            this.stream.write(100);
        } else if (String.class.equals((Object)c)) {
            this.stream.write(115);
        } else if (Character.class.equals((Object)c)) {
            this.stream.write(99);
        }
    }

    public void writeTypesArray(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            if (Boolean.TRUE.equals(array[i])) {
                this.stream.write(84);
                continue;
            }
            if (Boolean.FALSE.equals(array[i])) {
                this.stream.write(70);
                continue;
            }
            this.writeType(array[i].getClass());
        }
    }

    public void writeTypes(Collection<Object> types) {
        for (Object type : types) {
            if (null == type) continue;
            if (type.getClass().isArray()) {
                this.stream.write(91);
                this.writeTypesArray((Object[])type);
                this.stream.write(93);
                continue;
            }
            if (Boolean.TRUE.equals(type)) {
                this.stream.write(84);
                continue;
            }
            if (Boolean.FALSE.equals(type)) {
                this.stream.write(70);
                continue;
            }
            this.writeType(type.getClass());
        }
        this.appendNullCharToAlignStream();
    }

    private void writeUnderHandler(byte[] bytes) {
        try {
            this.stream.write(this.alignBigEndToFourByteBoundry(bytes));
        }
        catch (IOException e) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream");
        }
    }

    private void writeInteger32ToByteArray(int value) {
        this.intBytes[3] = (byte)value;
        this.intBytes[2] = (byte)(value >>>= 8);
        this.intBytes[1] = (byte)(value >>>= 8);
        this.intBytes[0] = (byte)(value >>>= 8);
        try {
            this.stream.write(this.intBytes);
        }
        catch (IOException ex) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream", ex);
        }
    }

    private void writeInteger64ToByteArray(long value) {
        this.longintBytes[7] = (byte)value;
        this.longintBytes[6] = (byte)(value >>>= 8);
        this.longintBytes[5] = (byte)(value >>>= 8);
        this.longintBytes[4] = (byte)(value >>>= 8);
        this.longintBytes[3] = (byte)(value >>>= 8);
        this.longintBytes[2] = (byte)(value >>>= 8);
        this.longintBytes[1] = (byte)(value >>>= 8);
        this.longintBytes[0] = (byte)(value >>>= 8);
        try {
            this.stream.write(this.longintBytes);
        }
        catch (IOException ex) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream", ex);
        }
    }
}

