/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSCByteArrayToJavaConverter {
    private byte[] bytes;
    private int bytesLength;
    private int streamPosition;

    public OSCPacket convert(byte[] byteArray, int bytesLength) {
        this.bytes = byteArray;
        this.bytesLength = bytesLength;
        this.streamPosition = 0;
        if (this.isBundle()) {
            return this.convertBundle();
        }
        return this.convertMessage();
    }

    private boolean isBundle() {
        String bytesAsString = new String(this.bytes, 0, 7);
        return bytesAsString.startsWith("#bundle");
    }

    private OSCBundle convertBundle() {
        this.streamPosition = 8;
        Date timestamp = this.readTimeTag();
        OSCBundle bundle = new OSCBundle(timestamp);
        OSCByteArrayToJavaConverter myConverter = new OSCByteArrayToJavaConverter();
        while (this.streamPosition < this.bytesLength) {
            int packetLength = (Integer)this.readInteger();
            byte[] packetBytes = new byte[packetLength];
            for (int i = 0; i < packetLength; ++i) {
                packetBytes[i] = this.bytes[this.streamPosition++];
            }
            OSCPacket packet = myConverter.convert(packetBytes, packetLength);
            bundle.addPacket(packet);
        }
        return bundle;
    }

    private OSCMessage convertMessage() {
        OSCMessage message = new OSCMessage();
        message.setAddress(this.readString());
        List<Character> types = this.readTypes();
        if (null == types) {
            return message;
        }
        this.moveToFourByteBoundry();
        for (int i = 0; i < types.size(); ++i) {
            if ('[' == types.get(i).charValue()) {
                message.addArgument(this.readArray(types, ++i).toArray());
                while (types.get(i).charValue() != ']') {
                    ++i;
                }
                continue;
            }
            message.addArgument(this.readArgument(types.get(i).charValue()));
        }
        return message;
    }

    private String readString() {
        int strLen = this.lengthOfCurrentString();
        char[] stringChars = new char[strLen];
        for (int i = 0; i < strLen; ++i) {
            stringChars[i] = (char)this.bytes[this.streamPosition++];
        }
        this.moveToFourByteBoundry();
        return new String(stringChars);
    }

    private List<Character> readTypes() {
        if (this.bytes[this.streamPosition] != 44) {
            return null;
        }
        ++this.streamPosition;
        int typesLen = this.lengthOfCurrentString();
        if (0 == typesLen) {
            return null;
        }
        ArrayList<Character> typesChars = new ArrayList<Character>(typesLen);
        for (int i = 0; i < typesLen; ++i) {
            typesChars.add(Character.valueOf((char)this.bytes[this.streamPosition++]));
        }
        return typesChars;
    }

    private Object readArgument(char type) {
        switch (type) {
            case 'i': {
                return this.readInteger();
            }
            case 'h': {
                return this.readBigInteger();
            }
            case 'f': {
                return this.readFloat();
            }
            case 'd': {
                return this.readDouble();
            }
            case 's': {
                return this.readString();
            }
            case 'c': {
                return this.readChar();
            }
            case 'T': {
                return Boolean.TRUE;
            }
            case 'F': {
                return Boolean.FALSE;
            }
            case 't': {
                return this.readTimeTag();
            }
        }
        return null;
    }

    private Object readChar() {
        return new Character((char)this.bytes[this.streamPosition++]);
    }

    private Object readDouble() {
        return this.readFloat();
    }

    private Object readFloat() {
        byte[] floatBytes = new byte[]{this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++]};
        BigInteger floatBits = new BigInteger(floatBytes);
        return new Float(Float.intBitsToFloat(floatBits.intValue()));
    }

    private Object readBigInteger() {
        byte[] longintBytes = new byte[]{this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++]};
        return new BigInteger(longintBytes);
    }

    private Object readInteger() {
        byte[] intBytes = new byte[]{this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++]};
        BigInteger intBits = new BigInteger(intBytes);
        return new Integer(intBits.intValue());
    }

    private Date readTimeTag() {
        int i;
        byte[] secondBytes = new byte[8];
        byte[] fractionBytes = new byte[8];
        for (int i2 = 0; i2 < 4; ++i2) {
            secondBytes[i2] = 0;
            fractionBytes[i2] = 0;
        }
        boolean isImmediate = true;
        for (i = 4; i < 8; ++i) {
            secondBytes[i] = this.bytes[this.streamPosition++];
            if (secondBytes[i] <= 0) continue;
            isImmediate = false;
        }
        for (i = 4; i < 8; ++i) {
            fractionBytes[i] = this.bytes[this.streamPosition++];
            if (i < 7) {
                if (fractionBytes[i] <= 0) continue;
                isImmediate = false;
                continue;
            }
            if (fractionBytes[i] <= 1) continue;
            isImmediate = false;
        }
        if (isImmediate) {
            return OSCBundle.TIMESTAMP_IMMEDIATE;
        }
        BigInteger secsSince1900 = new BigInteger(secondBytes);
        long secsSince1970 = secsSince1900.longValue() - OSCBundle.SECONDS_FROM_1900_TO_1970.longValue();
        if (secsSince1970 < 0L) {
            secsSince1970 = 0L;
        }
        long fraction = new BigInteger(fractionBytes).longValue();
        fraction = (fraction = fraction * 1000L / 0x100000000L) > 0L ? fraction + 1L : 0L;
        long millisecs = secsSince1970 * 1000L + fraction;
        return new Date(millisecs);
    }

    private List<Object> readArray(List<Character> types, int pos) {
        int arrayLen = 0;
        while (types.get(pos + arrayLen).charValue() != ']') {
            ++arrayLen;
        }
        ArrayList<Object> array = new ArrayList<Object>(arrayLen);
        for (int j = 0; j < arrayLen; ++j) {
            array.add(this.readArgument(types.get(pos + j).charValue()));
        }
        return array;
    }

    private int lengthOfCurrentString() {
        int i = 0;
        while (this.bytes[this.streamPosition + i] != 0) {
            ++i;
        }
        return i;
    }

    private void moveToFourByteBoundry() {
        int mod = this.streamPosition % 4;
        this.streamPosition += 4 - mod;
    }
}

