/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCPort;
import com.illposed.osc.utility.OSCByteArrayToJavaConverter;
import com.illposed.osc.utility.OSCPacketDispatcher;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public class OSCPortIn
extends OSCPort
implements Runnable {
    private boolean listening;
    private OSCByteArrayToJavaConverter converter = new OSCByteArrayToJavaConverter();
    private OSCPacketDispatcher dispatcher = new OSCPacketDispatcher();
    private static final int BUFFER_SIZE = 1536;

    public OSCPortIn(int port) throws SocketException {
        super(new DatagramSocket(port), port);
    }

    public void run() {
        byte[] buffer = new byte[1536];
        DatagramPacket packet = new DatagramPacket(buffer, 1536);
        DatagramSocket socket = this.getSocket();
        while (this.listening) {
            try {
                try {
                    socket.receive(packet);
                }
                catch (SocketException ex) {
                    if (!this.listening) continue;
                    throw ex;
                }
                OSCPacket oscPacket = this.converter.convert(buffer, packet.getLength());
                this.dispatcher.dispatchPacket(oscPacket);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void startListening() {
        this.listening = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void stopListening() {
        this.listening = false;
    }

    public boolean isListening() {
        return this.listening;
    }

    public void addListener(String anAddress, OSCListener listener) {
        this.dispatcher.addListener(anAddress, listener);
    }
}

