/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCJavaToByteArrayConverter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSCBundle
extends OSCPacket {
    public static final BigInteger SECONDS_FROM_1900_TO_1970 = new BigInteger("2208988800");
    public static final Date TIMESTAMP_IMMEDIATE = new Date(0L);
    private Date timestamp;
    private List<OSCPacket> packets;

    public OSCBundle() {
        this(TIMESTAMP_IMMEDIATE);
    }

    public OSCBundle(Date timestamp) {
        this((Collection<OSCPacket>)null, timestamp);
    }

    public OSCBundle(OSCPacket[] packets) {
        this(packets, TIMESTAMP_IMMEDIATE);
    }

    public OSCBundle(Collection<OSCPacket> packets) {
        this(packets, TIMESTAMP_IMMEDIATE);
    }

    public OSCBundle(OSCPacket[] packets, Date timestamp) {
        this(packets == null ? new LinkedList() : Arrays.asList(packets), timestamp);
    }

    public OSCBundle(Collection<OSCPacket> packets, Date timestamp) {
        this.packets = null == packets ? new LinkedList<OSCPacket>() : new ArrayList<OSCPacket>(packets);
        this.timestamp = timestamp;
        this.init();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void addPacket(OSCPacket packet) {
        this.packets.add(packet);
    }

    public OSCPacket[] getPackets() {
        OSCPacket[] packetArray = new OSCPacket[this.packets.size()];
        this.packets.toArray(packetArray);
        return packetArray;
    }

    protected void computeTimeTagByteArray(OSCJavaToByteArrayConverter stream) {
        if (null == this.timestamp || this.timestamp == TIMESTAMP_IMMEDIATE) {
            stream.write(0);
            stream.write(1);
            return;
        }
        long millisecs = this.timestamp.getTime();
        long secsSince1970 = millisecs / 1000L;
        long secs = secsSince1970 + SECONDS_FROM_1900_TO_1970.longValue();
        long fraction = millisecs % 1000L * 0x100000000L / 1000L;
        stream.write((int)secs);
        stream.write((int)fraction);
    }

    @Override
    protected byte[] computeByteArray(OSCJavaToByteArrayConverter stream) {
        stream.write("#bundle");
        this.computeTimeTagByteArray(stream);
        for (OSCPacket pkg : this.packets) {
            byte[] packetBytes = pkg.getByteArray();
            stream.write(packetBytes.length);
            stream.write(packetBytes);
        }
        return stream.toByteArray();
    }
}

